/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.nio.ByteBuffer;
import org.aoju.bus.core.io.PageBuffer;

public final class VirtualBuffer {
    private final PageBuffer pageBuffer;
    private ByteBuffer buffer;
    private boolean clean = false;
    private int parentPosition;
    private int parentLimit;

    VirtualBuffer(PageBuffer pageBuffer, ByteBuffer buffer, int parentPosition, int parentLimit) {
        this.pageBuffer = pageBuffer;
        this.buffer = buffer;
        this.parentPosition = parentPosition;
        this.parentLimit = parentLimit;
    }

    public static VirtualBuffer wrap(ByteBuffer buffer) {
        return new VirtualBuffer(null, buffer, 0, 0);
    }

    int getParentPosition() {
        return this.parentPosition;
    }

    void setParentPosition(int parentPosition) {
        this.parentPosition = parentPosition;
    }

    int getParentLimit() {
        return this.parentLimit;
    }

    void setParentLimit(int parentLimit) {
        this.parentLimit = parentLimit;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    void buffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.clean = false;
    }

    public void clean() {
        if (this.clean) {
            throw new UnsupportedOperationException("buffer has cleaned");
        }
        this.clean = true;
        if (null != this.pageBuffer) {
            this.pageBuffer.clean(this);
        }
    }

    public String toString() {
        return "VirtualBuffer{parentPosition=" + this.parentPosition + ", parentLimit=" + this.parentLimit + '}';
    }
}

