/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.UriKit;

public class FileResource
implements Resource {
    private final File file;

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, file.getName());
    }

    public FileResource(File file, String fileName) {
        this.file = file;
    }

    public FileResource(String path) {
        this(FileKit.file(path));
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public URL getUrl() {
        return UriKit.getURL(this.file);
    }

    @Override
    public InputStream getStream() {
        return FileKit.getInputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return null == this.file ? "null" : this.file.toString();
    }
}

