/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.key.UUID;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.thread.ExecutorBuilder;
import org.aoju.bus.core.thread.ThreadBuilder;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.Configure;
import org.aoju.bus.cron.CronTimer;
import org.aoju.bus.cron.Manager;
import org.aoju.bus.cron.Repertoire;
import org.aoju.bus.cron.Supervisor;
import org.aoju.bus.cron.factory.InvokeTask;
import org.aoju.bus.cron.factory.RunnableTask;
import org.aoju.bus.cron.factory.Task;
import org.aoju.bus.cron.listener.TaskListener;
import org.aoju.bus.cron.listener.TaskListenerManager;
import org.aoju.bus.cron.pattern.CronPattern;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.setting.magic.PopSetting;

public class Scheduler {
    private final Lock lock = new ReentrantLock();
    protected boolean daemon;
    protected Supervisor supervisor;
    protected Manager manager;
    protected ExecutorService threadExecutor;
    protected Configure config = new Configure();
    protected Repertoire repertoire = new Repertoire();
    protected TaskListenerManager listenerManager = new TaskListenerManager();
    private boolean started = false;
    private CronTimer timer;

    public Scheduler setTimeZone(TimeZone timeZone) {
        this.config.setTimeZone(timeZone);
        return this;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public Scheduler setDaemon(boolean on) throws InstrumentException {
        this.lock.lock();
        try {
            if (this.started) {
                throw new InstrumentException("Scheduler already started!");
            }
            this.daemon = on;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public boolean isMatchSecond() {
        return this.config.isMatchSecond();
    }

    public Scheduler setMatchSecond(boolean isMatchSecond) {
        this.config.setMatchSecond(isMatchSecond);
        return this;
    }

    public Scheduler addListener(TaskListener listener) {
        this.listenerManager.addListener(listener);
        return this;
    }

    public Scheduler removeListener(TaskListener listener) {
        this.listenerManager.removeListener(listener);
        return this;
    }

    public Scheduler schedule(PopSetting cronSetting) {
        if (CollKit.isNotEmpty(cronSetting)) {
            for (Map.Entry groupedEntry : cronSetting.getGroupMap().entrySet()) {
                String group = (String)groupedEntry.getKey();
                for (Map.Entry entry : ((LinkedHashMap)groupedEntry.getValue()).entrySet()) {
                    String jobClass = (String)entry.getKey();
                    if (StringKit.isNotBlank(group)) {
                        jobClass = group + "." + jobClass;
                    }
                    String pattern = (String)entry.getValue();
                    Logger.debug("Load job: {} {}", pattern, jobClass);
                    try {
                        this.schedule(pattern, new InvokeTask(jobClass));
                    }
                    catch (Exception e) {
                        throw new InstrumentException("Schedule [{}] [{}] error!", pattern, jobClass);
                    }
                }
            }
        }
        return this;
    }

    public String schedule(String pattern, Runnable task) {
        return this.schedule(pattern, new RunnableTask(task));
    }

    public String schedule(String pattern, Task task) {
        String id = UUID.randomUUID().toString();
        this.schedule(id, pattern, task);
        return id;
    }

    public Scheduler schedule(String id, String pattern, Runnable task) {
        return this.schedule(id, new CronPattern(pattern), (Task)new RunnableTask(task));
    }

    public Scheduler schedule(String id, String pattern, Task task) {
        return this.schedule(id, new CronPattern(pattern), task);
    }

    public Scheduler schedule(String id, CronPattern pattern, Task task) {
        this.repertoire.add(id, pattern, task);
        return this;
    }

    public Scheduler deschedule(String id) {
        this.repertoire.remove(id);
        return this;
    }

    public Scheduler updatePattern(String id, CronPattern pattern) {
        this.repertoire.updatePattern(id, pattern);
        return this;
    }

    public Repertoire getTaskTable() {
        return this.repertoire;
    }

    public CronPattern getPattern(String id) {
        return this.repertoire.getPattern(id);
    }

    public Task getTask(String id) {
        return this.repertoire.getTask(id);
    }

    public boolean isEmpty() {
        return this.repertoire.isEmpty();
    }

    public int size() {
        return this.repertoire.size();
    }

    public Scheduler clear() {
        this.repertoire = new Repertoire();
        return this;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Scheduler start(boolean isDeamon) {
        this.daemon = isDeamon;
        return this.start();
    }

    public Scheduler start() {
        this.lock.lock();
        try {
            if (this.started) {
                throw new InstrumentException("Schedule is started!");
            }
            this.threadExecutor = ExecutorBuilder.create().useSynchronousQueue().setThreadFactory(ThreadBuilder.create().setNamePrefix("exec-cron-").setDaemon(this.daemon).build()).build();
            this.supervisor = new Supervisor(this);
            this.manager = new Manager(this);
            this.timer = new CronTimer(this);
            this.timer.setDaemon(this.daemon);
            this.timer.start();
            this.started = true;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public Scheduler stop() {
        return this.stop(false);
    }

    public Scheduler stop(boolean clearTasks) {
        this.lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Scheduler not started !");
            }
            this.timer.stopTimer();
            this.timer = null;
            this.threadExecutor.shutdown();
            this.threadExecutor = null;
            if (clearTasks) {
                this.clear();
            }
            this.started = false;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }
}

