/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.pinyin;

import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.pinyin.PinyinFactory;
import org.aoju.bus.extra.pinyin.PinyinProvider;

public class PinyinKit {
    public static PinyinProvider getProvider() {
        return PinyinFactory.get();
    }

    public static String getPinyin(char c) {
        return PinyinKit.getProvider().getPinyin(c);
    }

    public static String getPinyin(String str) {
        return PinyinKit.getPinyin(str, " ");
    }

    public static String getPinyin(String str, String separator) {
        return PinyinKit.getProvider().getPinyin(str, separator);
    }

    public static char getFirstLetter(char c) {
        return PinyinKit.getProvider().getFirstLetter(c);
    }

    public static String getFirstLetter(String str, String separator) {
        return PinyinKit.getProvider().getFirstLetter(str, separator);
    }

    private static int getChsAscii(String chs) {
        int asc;
        byte[] bytes = chs.getBytes(Charset.GBK);
        switch (bytes.length) {
            case 1: {
                asc = bytes[0];
                break;
            }
            case 2: {
                int hightByte = 256 + bytes[0];
                int lowByte = 256 + bytes[1];
                asc = 256 * hightByte + lowByte - 65536;
                break;
            }
            default: {
                throw new InstrumentException("Illegal resource string");
            }
        }
        return asc;
    }

    public static boolean isChinese(char c) {
        return '\u3007' == c || String.valueOf(c).matches("[\u4e00-\u9fff]");
    }

    public static boolean isChinese(String c) {
        if (StringKit.isEmpty(c)) {
            return false;
        }
        return c.matches("[\u4e00-\u9fff]");
    }
}

