/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.builtin.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.ComputerSystem;
import org.aoju.bus.health.builtin.hardware.Firmware;

@Immutable
public abstract class AbstractComputerSystem
implements ComputerSystem {
    private final Supplier<Firmware> firmware = Memoize.memoize(this::createFirmware);
    private final Supplier<Baseboard> baseboard = Memoize.memoize(this::createBaseboard);

    @Override
    public Firmware getFirmware() {
        return this.firmware.get();
    }

    protected abstract Firmware createFirmware();

    @Override
    public Baseboard getBaseboard() {
        return this.baseboard.get();
    }

    protected abstract Baseboard createBaseboard();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("manufacturer=").append(this.getManufacturer()).append(", ");
        sb.append("model=").append(this.getModel()).append(", ");
        sb.append("serial number=").append(this.getSerialNumber()).append(", ");
        sb.append("uuid=").append(this.getHardwareUUID());
        return sb.toString();
    }
}

