/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractFirmware;
import org.aoju.bus.health.linux.drivers.Dmidecode;
import org.aoju.bus.health.linux.drivers.Sysfs;

@Immutable
final class LinuxFirmware
extends AbstractFirmware {
    private static final DateTimeFormatter VCGEN_FORMATTER = DateTimeFormatter.ofPattern("MMM d uuuu HH:mm:ss", Locale.ENGLISH);
    private final Supplier<VcGenCmdStrings> vcGenCmd = Memoize.memoize(LinuxFirmware::queryVcGenCmd);
    private final Supplier<String> manufacturer = Memoize.memoize(this::queryManufacturer);
    private final Supplier<String> description = Memoize.memoize(this::queryDescription);
    private final Supplier<String> releaseDate = Memoize.memoize(this::queryReleaseDate);
    private final Supplier<Pair<String, String>> biosNameRev = Memoize.memoize(Dmidecode::queryBiosNameRev);
    private final Supplier<String> version = Memoize.memoize(this::queryVersion);
    private final Supplier<String> name = Memoize.memoize(this::queryName);

    LinuxFirmware() {
    }

    private static VcGenCmdStrings queryVcGenCmd() {
        List<String> vcgencmd = Executor.runNative("vcgencmd version");
        if (vcgencmd.size() >= 3) {
            String vcReleaseDate;
            try {
                vcReleaseDate = DateTimeFormatter.ISO_LOCAL_DATE.format(VCGEN_FORMATTER.parse(vcgencmd.get(0)));
            }
            catch (DateTimeParseException e) {
                vcReleaseDate = "unknown";
            }
            String[] copyright = RegEx.SPACES.split(vcgencmd.get(1));
            String vcManufacturer = copyright[copyright.length - 1];
            String vcVersion = vcgencmd.get(2).replace("version ", "");
            return new VcGenCmdStrings(vcReleaseDate, vcManufacturer, vcVersion, "RPi", "Bootloader");
        }
        return new VcGenCmdStrings(null, null, null, null, null);
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer.get();
    }

    @Override
    public String getDescription() {
        return this.description.get();
    }

    @Override
    public String getVersion() {
        return this.version.get();
    }

    @Override
    public String getReleaseDate() {
        return this.releaseDate.get();
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    private String queryManufacturer() {
        String result = Sysfs.queryBiosVendor();
        if (null == result && null == (result = this.vcGenCmd.get().manufacturer)) {
            return "unknown";
        }
        return result;
    }

    private String queryDescription() {
        String result = Sysfs.queryBiosDescription();
        if (null == result && null == (result = this.vcGenCmd.get().description)) {
            return "unknown";
        }
        return result;
    }

    private String queryVersion() {
        String result = Sysfs.queryBiosVersion(this.biosNameRev.get().getLeft());
        if (null == result && null == (result = this.vcGenCmd.get().version)) {
            return "unknown";
        }
        return result;
    }

    private String queryReleaseDate() {
        String result = Sysfs.queryBiosReleaseDate();
        if (null == result && null == (result = this.vcGenCmd.get().releaseDate)) {
            return "unknown";
        }
        return result;
    }

    private String queryName() {
        String result = this.biosNameRev.get().getLeft();
        if (null == result && null == (result = this.vcGenCmd.get().name)) {
            return "unknown";
        }
        return result;
    }

    private static final class VcGenCmdStrings {
        private final String releaseDate;
        private final String manufacturer;
        private final String version;
        private final String name;
        private final String description;

        private VcGenCmdStrings(String releaseDate, String manufacturer, String version, String name, String description) {
            this.releaseDate = releaseDate;
            this.manufacturer = manufacturer;
            this.version = version;
            this.name = name;
            this.description = description;
        }
    }
}

