/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.tuple.Quintet;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractFirmware;

@Immutable
final class MacFirmware
extends AbstractFirmware {
    private final Supplier<Quintet<String, String, String, String, String>> manufNameDescVersRelease = Memoize.memoize(MacFirmware::queryEfi);

    MacFirmware() {
    }

    private static Quintet<String, String, String, String, String> queryEfi() {
        String manufacturer = null;
        String name = null;
        String description = null;
        String version = null;
        String releaseDate = null;
        IOKit.IOService platformExpert = IOKitUtil.getMatchingService((String)"IOPlatformExpertDevice");
        if (null != platformExpert) {
            byte[] data;
            IOKit.IOIterator iter = platformExpert.getChildIterator("IODeviceTree");
            if (null != iter) {
                IOKit.IORegistryEntry entry = iter.next();
                while (null != entry) {
                    switch (entry.getName()) {
                        case "rom": {
                            data = entry.getByteArrayProperty("vendor");
                            if (null != data) {
                                manufacturer = Native.toString((byte[])data, (java.nio.charset.Charset)Charset.UTF_8);
                            }
                            if (null != (data = entry.getByteArrayProperty("version"))) {
                                version = Native.toString((byte[])data, (java.nio.charset.Charset)Charset.UTF_8);
                            }
                            if (null == (data = entry.getByteArrayProperty("release-date"))) break;
                            releaseDate = Native.toString((byte[])data, (java.nio.charset.Charset)Charset.UTF_8);
                            break;
                        }
                        case "chosen": {
                            data = entry.getByteArrayProperty("booter-name");
                            if (null == data) break;
                            name = Native.toString((byte[])data, (java.nio.charset.Charset)Charset.UTF_8);
                            break;
                        }
                        case "efi": {
                            data = entry.getByteArrayProperty("firmware-abi");
                            if (null == data) break;
                            description = Native.toString((byte[])data, (java.nio.charset.Charset)Charset.UTF_8);
                            break;
                        }
                        default: {
                            if (!StringKit.isBlank(name)) break;
                            name = entry.getStringProperty("IONameMatch");
                        }
                    }
                    entry.release();
                    entry = iter.next();
                }
                iter.release();
            }
            if (StringKit.isBlank(manufacturer) && null != (data = platformExpert.getByteArrayProperty("manufacturer"))) {
                manufacturer = Native.toString((byte[])data, (java.nio.charset.Charset)StandardCharsets.UTF_8);
            }
            if (StringKit.isBlank(version) && null != (data = platformExpert.getByteArrayProperty("target-type"))) {
                version = Native.toString((byte[])data, (java.nio.charset.Charset)StandardCharsets.UTF_8);
            }
            if (StringKit.isBlank(name) && null != (data = platformExpert.getByteArrayProperty("device_type"))) {
                name = Native.toString((byte[])data, (java.nio.charset.Charset)StandardCharsets.UTF_8);
            }
            platformExpert.release();
        }
        return new Quintet<String, String, String, String, String>(StringKit.isBlank(manufacturer) ? "unknown" : manufacturer, StringKit.isBlank(name) ? "unknown" : name, StringKit.isBlank(description) ? "unknown" : description, StringKit.isBlank(version) ? "unknown" : version, StringKit.isBlank(releaseDate) ? "unknown" : releaseDate);
    }

    @Override
    public String getManufacturer() {
        return this.manufNameDescVersRelease.get().getA();
    }

    @Override
    public String getName() {
        return this.manufNameDescVersRelease.get().getB();
    }

    @Override
    public String getDescription() {
        return this.manufNameDescVersRelease.get().getC();
    }

    @Override
    public String getVersion() {
        return this.manufNameDescVersRelease.get().getD();
    }

    @Override
    public String getReleaseDate() {
        return this.manufNameDescVersRelease.get().getE();
    }
}

