/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.software;

import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractOperatingSystem;
import org.aoju.bus.health.builtin.software.FileSystem;
import org.aoju.bus.health.builtin.software.InternetProtocolStats;
import org.aoju.bus.health.builtin.software.NetworkParams;
import org.aoju.bus.health.builtin.software.OSDesktopWindow;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSService;
import org.aoju.bus.health.builtin.software.OSSession;
import org.aoju.bus.health.builtin.software.OperatingSystem;
import org.aoju.bus.health.mac.SysctlKit;
import org.aoju.bus.health.mac.drivers.Who;
import org.aoju.bus.health.mac.drivers.WindowInfo;
import org.aoju.bus.health.mac.software.MacFileSystem;
import org.aoju.bus.health.mac.software.MacInternetProtocolStats;
import org.aoju.bus.health.mac.software.MacNetworkParams;
import org.aoju.bus.health.mac.software.MacOSProcess;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class MacOperatingSystem
extends AbstractOperatingSystem {
    private static final String SYSTEM_LIBRARY_LAUNCH_AGENTS = "/System/Library/LaunchAgents";
    private static final String SYSTEM_LIBRARY_LAUNCH_DAEMONS = "/System/Library/LaunchDaemons";
    private static final long BOOTTIME;
    private final String osXVersion;
    private final int major;
    private final int minor;
    private int maxProc = 1024;

    public MacOperatingSystem() {
        String version = System.getProperty("os.version");
        int verMajor = Builder.getFirstIntValue(version);
        int verMinor = Builder.getNthIntValue(version, 2);
        if (verMajor == 10 && verMinor > 15) {
            String swVers = Executor.getFirstAnswer("sw_vers -productVersion");
            if (!swVers.isEmpty()) {
                version = swVers;
            }
            verMajor = Builder.getFirstIntValue(version);
            verMinor = Builder.getNthIntValue(version, 2);
        }
        this.osXVersion = version;
        this.major = verMajor;
        this.minor = verMinor;
        this.maxProc = SysctlKit.sysctl("kern.maxproc", 4096);
    }

    private static int getParentProcessPid(int pid) {
        SystemB.ProcTaskAllInfo taskAllInfo = new SystemB.ProcTaskAllInfo();
        if (0 > SystemB.INSTANCE.proc_pidinfo(pid, 2, 0L, (Structure)taskAllInfo, taskAllInfo.size())) {
            return 0;
        }
        return taskAllInfo.pbsd.pbi_ppid;
    }

    @Override
    public String queryManufacturer() {
        return "Apple";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        String family = this.major > 10 || this.major == 10 && this.minor >= 12 ? "macOS" : System.getProperty("os.name");
        String codeName = this.parseCodeName();
        String buildNumber = SysctlKit.sysctl("kern.osversion", "");
        return Pair.of(family, new OperatingSystem.OSVersionInfo(this.osXVersion, codeName, buildNumber));
    }

    @Override
    protected int queryBitness(int jvmBitness) {
        if (jvmBitness == 64 || this.major == 10 && this.minor > 6) {
            return 64;
        }
        return Builder.parseIntOrDefault(Executor.getFirstAnswer("getconf LONG_BIT"), 32);
    }

    @Override
    public FileSystem getFileSystem() {
        return new MacFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new MacInternetProtocolStats(this.isElevated());
    }

    @Override
    public List<OSSession> getSessions() {
        return USE_WHO_COMMAND ? super.getSessions() : Who.queryUtxent();
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        ArrayList<OSProcess> procs = new ArrayList<OSProcess>();
        int[] pids = new int[this.maxProc];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length * SystemB.INT_SIZE) / SystemB.INT_SIZE;
        for (int i = 0; i < numberOfProcesses; ++i) {
            OSProcess proc;
            if (pids[i] == 0 || null == (proc = this.getProcess(pids[i]))) continue;
            procs.add(proc);
        }
        return procs;
    }

    @Override
    public List<OSProcess> queryChildProcesses(int parentPid) {
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = MacOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, false);
        return allProcs.stream().filter(p -> descendantPids.contains(p.getProcessID())).collect(Collectors.toList());
    }

    @Override
    public List<OSProcess> queryDescendantProcesses(int parentPid) {
        List<OSProcess> allProcs = this.queryAllProcesses();
        Set<Integer> descendantPids = MacOperatingSystem.getChildrenOrDescendants(allProcs, parentPid, true);
        return allProcs.stream().filter(p -> descendantPids.contains(p.getProcessID())).collect(Collectors.toList());
    }

    @Override
    public OSProcess getProcess(int pid) {
        MacOSProcess proc = new MacOSProcess(pid, this.minor);
        return proc.getState().equals((Object)OSProcess.State.INVALID) ? null : proc;
    }

    @Override
    public int getProcessId() {
        return SystemB.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return SystemB.INSTANCE.proc_listpids(1, 0, null, 0) / SystemB.INT_SIZE;
    }

    @Override
    public int getThreadCount() {
        int[] pids = new int[this.getProcessCount() + 10];
        int numberOfProcesses = SystemB.INSTANCE.proc_listpids(1, 0, pids, pids.length) / SystemB.INT_SIZE;
        int numberOfThreads = 0;
        SystemB.ProcTaskInfo taskInfo = new SystemB.ProcTaskInfo();
        for (int i = 0; i < numberOfProcesses; ++i) {
            int exit = SystemB.INSTANCE.proc_pidinfo(pids[i], 4, 0L, (Structure)taskInfo, taskInfo.size());
            if (exit == -1) continue;
            numberOfThreads += taskInfo.pti_threadnum;
        }
        return numberOfThreads;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new MacNetworkParams();
    }

    @Override
    public OSService[] getServices() {
        ArrayList<OSService> services = new ArrayList<OSService>();
        HashSet<String> running = new HashSet<String>();
        for (OSProcess p : this.getChildProcesses(1, OperatingSystem.ProcessFiltering.ALL_PROCESSES, OperatingSystem.ProcessSorting.PID_ASC, 0)) {
            OSService s = new OSService(p.getName(), p.getProcessID(), OSService.State.RUNNING);
            services.add(s);
            running.add(p.getName());
        }
        ArrayList<File> files = new ArrayList<File>();
        File dir = new File(SYSTEM_LIBRARY_LAUNCH_AGENTS);
        if (dir.exists() && dir.isDirectory()) {
            files.addAll(Arrays.asList(dir.listFiles((f, name) -> name.toLowerCase().endsWith(".plist"))));
        } else {
            Logger.error("Directory: /System/Library/LaunchAgents does not exist", new Object[0]);
        }
        dir = new File(SYSTEM_LIBRARY_LAUNCH_DAEMONS);
        if (dir.exists() && dir.isDirectory()) {
            files.addAll(Arrays.asList(dir.listFiles((f, name) -> name.toLowerCase().endsWith(".plist"))));
        } else {
            Logger.error("Directory: /System/Library/LaunchDaemons does not exist", new Object[0]);
        }
        for (File f2 : files) {
            String shortName;
            String name2 = f2.getName().substring(0, f2.getName().length() - 6);
            int index = name2.lastIndexOf(46);
            String string = shortName = index < 0 || index > name2.length() - 2 ? name2 : name2.substring(index + 1);
            if (running.contains(name2) || running.contains(shortName)) continue;
            OSService s = new OSService(name2, 0, OSService.State.STOPPED);
            services.add(s);
        }
        return services.toArray(new OSService[0]);
    }

    @Override
    public List<OSDesktopWindow> getDesktopWindows(boolean visibleOnly) {
        return WindowInfo.queryDesktopWindows(visibleOnly);
    }

    private String parseCodeName() {
        if (this.major > 10) {
            switch (this.major) {
                case 12: {
                    return "Monterey";
                }
                case 11: {
                    return "Big Sur";
                }
            }
        } else if (this.major == 10) {
            switch (this.minor) {
                case 15: {
                    return "Catalina";
                }
                case 14: {
                    return "Mojave";
                }
                case 13: {
                    return "High Sierra";
                }
                case 12: {
                    return "Sierra";
                }
                case 11: {
                    return "El Capitan";
                }
                case 10: {
                    return "Yosemite";
                }
                case 9: {
                    return "Mavericks";
                }
                case 8: {
                    return "Mountain Lion";
                }
                case 7: {
                    return "Lion";
                }
                case 6: {
                    return "Snow Leopard";
                }
                case 5: {
                    return "Leopard";
                }
                case 4: {
                    return "Tiger";
                }
                case 3: {
                    return "Panther";
                }
                case 2: {
                    return "Jaguar";
                }
                case 1: {
                    return "Puma";
                }
                case 0: {
                    return "Cheetah";
                }
            }
        }
        Logger.warn("Unable to parse version {}.{} to a codename.", this.major, this.minor);
        return "Big Sur";
    }

    static {
        SystemB.Timeval tv = new SystemB.Timeval();
        BOOTTIME = !SysctlKit.sysctl("kern.boottime", (Structure)tv) || tv.tv_sec.longValue() == 0L ? Builder.parseLongOrDefault(Executor.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : tv.tv_sec.longValue();
    }
}

