/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.hardware;

import com.sun.jna.Native;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.builtin.hardware.AbstractHWDiskStore;
import org.aoju.bus.health.builtin.hardware.HWDiskStore;
import org.aoju.bus.health.builtin.hardware.HWPartition;
import org.aoju.bus.health.unix.aix.drivers.Ls;
import org.aoju.bus.health.unix.aix.drivers.Lscfg;
import org.aoju.bus.health.unix.aix.drivers.Lspv;

@ThreadSafe
public final class AixHWDiskStore
extends AbstractHWDiskStore {
    private final Supplier<Perfstat.perfstat_disk_t[]> diskStats;
    private long reads = 0L;
    private long readBytes = 0L;
    private long writes = 0L;
    private long writeBytes = 0L;
    private long currentQueueLength = 0L;
    private long transferTime = 0L;
    private long timeStamp = 0L;
    private List<HWPartition> partitionList;

    private AixHWDiskStore(String name, String model, String serial, long size, Supplier<Perfstat.perfstat_disk_t[]> diskStats) {
        super(name, model, serial, size);
        this.diskStats = diskStats;
    }

    public static List<HWDiskStore> getDisks(Supplier<Perfstat.perfstat_disk_t[]> diskStats) {
        Map<String, Pair<Integer, Integer>> majMinMap = Ls.queryDeviceMajorMinor();
        ArrayList<AixHWDiskStore> storeList = new ArrayList<AixHWDiskStore>();
        for (Perfstat.perfstat_disk_t disk : diskStats.get()) {
            String storeName = Native.toString((byte[])disk.name);
            Pair<String, String> ms = Lscfg.queryModelSerial(storeName);
            String model = null == ms.getLeft() ? Native.toString((byte[])disk.description) : ms.getLeft();
            String serial = null == ms.getRight() ? "unknown" : ms.getRight();
            storeList.add(AixHWDiskStore.createStore(storeName, model, serial, disk.size << 20, diskStats, majMinMap));
        }
        return storeList.stream().sorted(Comparator.comparingInt(s -> s.getPartitions().isEmpty() ? Integer.MAX_VALUE : s.getPartitions().get(0).getMajor())).collect(Collectors.toList());
    }

    private static AixHWDiskStore createStore(String diskName, String model, String serial, long size, Supplier<Perfstat.perfstat_disk_t[]> diskStats, Map<String, Pair<Integer, Integer>> majMinMap) {
        AixHWDiskStore store = new AixHWDiskStore(diskName, model.isEmpty() ? "unknown" : model, serial, size, diskStats);
        store.partitionList = Collections.unmodifiableList(Lspv.queryLogicalVolumes(diskName, majMinMap).stream().sorted(Comparator.comparing(HWPartition::getMinor).thenComparing(HWPartition::getName)).collect(Collectors.toList()));
        store.updateAttributes();
        return store;
    }

    @Override
    public long getReads() {
        return this.reads;
    }

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getWrites() {
        return this.writes;
    }

    @Override
    public long getWriteBytes() {
        return this.writeBytes;
    }

    @Override
    public long getCurrentQueueLength() {
        return this.currentQueueLength;
    }

    @Override
    public long getTransferTime() {
        return this.transferTime;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public List<HWPartition> getPartitions() {
        return this.partitionList;
    }

    @Override
    public boolean updateAttributes() {
        for (Perfstat.perfstat_disk_t stat : this.diskStats.get()) {
            String name = Native.toString((byte[])stat.name);
            if (!name.equals(this.getName())) continue;
            long blks = stat.rblks + stat.wblks;
            this.reads = stat.xfers;
            if (blks > 0L) {
                this.writes = stat.xfers * stat.wblks / blks;
                this.reads -= this.writes;
            }
            this.readBytes = stat.rblks * stat.bsize;
            this.writeBytes = stat.wblks * stat.bsize;
            this.currentQueueLength = stat.qdepth;
            this.transferTime = stat.time;
            return true;
        }
        return false;
    }
}

