/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.socket.CoverWebSocket;
import org.aoju.bus.logger.Logger;

public class Stomp {
    public static final String SUPPORTED_VERSIONS = "1.1,1.2";
    public static final String AUTO_ACK = "auto";
    public static final String CLIENT_ACK = "client";
    private static final String TOPIC = "/topic";
    private static final String QUEUE = "/queue";
    private final boolean autoAck;
    private final CoverWebSocket.Client cover;
    private final Map<String, Subscriber> subscribers;
    private boolean connected;
    private CoverWebSocket websocket;
    private boolean legacyWhitespace = false;
    private OnBack<Stomp> onConnected;
    private OnBack<CoverWebSocket.Close> onDisconnected;
    private OnBack<Message> onError;

    private Stomp(CoverWebSocket.Client cover, boolean autoAck) {
        this.cover = cover;
        this.autoAck = autoAck;
        this.subscribers = new HashMap<String, Subscriber>();
    }

    public static Stomp over(CoverWebSocket.Client task) {
        return Stomp.over(task, true);
    }

    public static Stomp over(CoverWebSocket.Client task, boolean autoAck) {
        return new Stomp(task, autoAck);
    }

    public Stomp connect() {
        return this.connect(null);
    }

    public Stomp connect(List<Header> headers) {
        if (this.connected) {
            return this;
        }
        this.cover.setOnOpen((ws, res) -> {
            ArrayList<Header> cHeaders = new ArrayList<Header>();
            cHeaders.add(new Header("accept-version", SUPPORTED_VERSIONS));
            cHeaders.add(new Header("heart-beat", this.cover.pingSeconds() * 1000 + "," + this.cover.pongSeconds() * 1000));
            if (null != headers) {
                cHeaders.addAll(headers);
            }
            this.send(new Message("CONNECT", cHeaders, null));
        });
        this.cover.setOnMessage((ws, msg) -> {
            Message message = Message.from(msg.toString());
            if (null != message) {
                this.receive(message);
            }
        });
        this.cover.setOnClosed((ws, close) -> {
            if (null != this.onDisconnected) {
                this.onDisconnected.on((CoverWebSocket.Close)close);
            }
        });
        this.websocket = this.cover.listen();
        return this;
    }

    public void disconnect() {
        if (null != this.websocket) {
            this.websocket.close(1000, "disconnect by user");
        }
    }

    public Stomp setOnConnected(OnBack<Stomp> onConnected) {
        this.onConnected = onConnected;
        return this;
    }

    public Stomp setOnDisconnected(OnBack<CoverWebSocket.Close> onDisconnected) {
        this.onDisconnected = onDisconnected;
        return this;
    }

    public Stomp setOnError(OnBack<Message> onError) {
        this.onError = onError;
        return this;
    }

    public void sendTo(String destination, String data) {
        this.send(new Message("SEND", Collections.singletonList(new Header("destination", destination)), data));
    }

    public void send(Message message) {
        if (null == this.websocket) {
            throw new IllegalArgumentException("You must call connect before send");
        }
        this.websocket.send(message.compile(this.legacyWhitespace));
    }

    public Stomp topic(String destination, OnBack<Message> callback) {
        return this.topic(destination, null, callback);
    }

    public Stomp topic(String destination, List<Header> headers, OnBack<Message> callback) {
        return this.subscribe(TOPIC + destination, headers, callback);
    }

    public Stomp queue(String destination, OnBack<Message> callback) {
        return this.queue(destination, null, callback);
    }

    public Stomp queue(String destination, List<Header> headers, OnBack<Message> callback) {
        return this.subscribe(QUEUE + destination, headers, callback);
    }

    public synchronized Stomp subscribe(String destination, List<Header> headers, OnBack<Message> callback) {
        if (this.subscribers.containsKey(destination)) {
            Logger.error("Attempted to subscribe to already-subscribed path!", new Object[0]);
            return this;
        }
        Subscriber subscriber = new Subscriber(UUID.randomUUID().toString(), destination, callback, headers);
        this.subscribers.put(destination, subscriber);
        subscriber.subscribe();
        return this;
    }

    public void ack(Message message) {
        Header subscription = message.header("subscription");
        Header msgId = message.header("message-id");
        if (null != subscription || null != msgId) {
            ArrayList<Header> headers = new ArrayList<Header>();
            headers.add(subscription);
            headers.add(msgId);
            this.send(new Message("ACK", headers, null));
        } else {
            Logger.error("subscription and message-id not found in " + message.toString() + ", so it can not be ack!", new Object[0]);
        }
    }

    public void untopic(String destination) {
        this.unsubscribe(TOPIC + destination);
    }

    public void unqueue(String destination) {
        this.unsubscribe(QUEUE + destination);
    }

    public synchronized void unsubscribe(String destination) {
        Subscriber subscriber = this.subscribers.remove(destination);
        if (null != subscriber) {
            subscriber.unsubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receive(Message msg) {
        String command = msg.getCommand();
        if ("CONNECTED".equals(command)) {
            String[] heartbeats;
            String hbHeader = msg.headerValue("heart-beat");
            if (null != hbHeader) {
                heartbeats = hbHeader.split(",");
                int pingSeconds = Integer.parseInt(heartbeats[1]) / 1000;
                int pongSeconds = Integer.parseInt(heartbeats[0]) / 1000;
                this.cover.heatbeat(Math.max(pingSeconds, this.cover.pingSeconds()), Math.max(pongSeconds, this.cover.pongSeconds()));
            }
            heartbeats = this;
            synchronized (this) {
                this.connected = true;
                for (Subscriber s : this.subscribers.values()) {
                    s.subscribe();
                }
                // ** MonitorExit[heartbeats] (shouldn't be in output)
                if (null != this.onConnected) {
                    this.onConnected.on((Stomp)this);
                }
            }
        } else if ("MESSAGE".equals(command)) {
            String id = msg.headerValue("subscription");
            String destination = msg.headerValue("destination");
            if (null == id || null == destination) {
                return;
            }
            Subscriber subscriber = this.subscribers.get(destination);
            if (null != subscriber && id.equals(subscriber.id)) {
                subscriber.callback.on(msg);
            }
        } else if ("ERROR".equals(command) && null != this.onError) {
            this.onError.on(msg);
        }
    }

    public void setLegacyWhitespace(boolean legacyWhitespace) {
        this.legacyWhitespace = legacyWhitespace;
    }

    class Subscriber {
        private final String id;
        private final String destination;
        private final OnBack<Message> callback;
        private final List<Header> headers;
        private boolean subscribed;

        Subscriber(String id, String destination, OnBack<Message> callback, List<Header> headers) {
            this.id = id;
            this.destination = destination;
            this.callback = callback;
            this.headers = headers;
        }

        void subscribe() {
            if (Stomp.this.connected && !this.subscribed) {
                ArrayList<Header> headers = new ArrayList<Header>();
                headers.add(new Header("id", this.id));
                headers.add(new Header("destination", this.destination));
                boolean ackNotAdded = true;
                if (null != this.headers) {
                    for (Header header : this.headers) {
                        String key;
                        if ("ack".equals(header.getKey())) {
                            ackNotAdded = false;
                        }
                        if ("id".equals(key = header.getKey()) || "destination".equals(key)) continue;
                        headers.add(header);
                    }
                }
                if (ackNotAdded) {
                    headers.add(new Header("ack", Stomp.this.autoAck ? Stomp.AUTO_ACK : Stomp.CLIENT_ACK));
                }
                Stomp.this.send(new Message("SUBSCRIBE", headers, null));
                this.subscribed = true;
            }
        }

        void unsubscribe() {
            List<Header> headers = Collections.singletonList(new Header("id", this.id));
            Stomp.this.send(new Message("UNSUBSCRIBE", headers, null));
            this.subscribed = false;
        }
    }

    public static class Message {
        private final String command;
        private final List<Header> headers;
        private final String payload;

        public Message(String command, List<Header> headers, String payload) {
            this.command = command;
            this.headers = headers;
            this.payload = payload;
        }

        public static Message from(String data) {
            int mhIndex;
            if (null == data || data.trim().isEmpty()) {
                return new Message("UNKNOWN", null, data);
            }
            int cmdIndex = data.indexOf("\n");
            if (cmdIndex >= (mhIndex = data.indexOf("\n\n"))) {
                Logger.error("\u975e\u6cd5\u7684 STOMP \u6d88\u606f\uff1a" + data, new Object[0]);
                return null;
            }
            String command = data.substring(0, cmdIndex);
            String[] headers = data.substring(cmdIndex + 1, mhIndex).split("\n");
            ArrayList<Header> headerList = new ArrayList<Header>(headers.length);
            for (String header : headers) {
                String[] hv = header.split(":");
                if (hv.length != 2) continue;
                headerList.add(new Header(hv[0], hv[1]));
            }
            String payload = null;
            if (data.length() > mhIndex + 2) {
                if (data.endsWith("\u0000\n") && data.length() > mhIndex + 4) {
                    payload = data.substring(mhIndex + 2, data.length() - 2);
                } else if (data.endsWith("\u0000") && data.length() > mhIndex + 3) {
                    payload = data.substring(mhIndex + 2, data.length() - 1);
                }
            }
            return new Message(command, headerList, payload);
        }

        public List<Header> getHeaders() {
            return this.headers;
        }

        public String getPayload() {
            return this.payload;
        }

        public String getCommand() {
            return this.command;
        }

        public String headerValue(String key) {
            Header header = this.header(key);
            if (null != header) {
                return header.getValue();
            }
            return null;
        }

        public Header header(String key) {
            if (null != this.headers) {
                for (Header header : this.headers) {
                    if (!header.getKey().equals(key)) continue;
                    return header;
                }
            }
            return null;
        }

        public String compile(boolean legacyWhitespace) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.command).append('\n');
            for (Header header : this.headers) {
                builder.append(header.getKey()).append(':').append(header.getValue()).append('\n');
            }
            builder.append('\n');
            if (null != this.payload) {
                builder.append(this.payload);
                if (legacyWhitespace) {
                    builder.append("\n\n");
                }
            }
            builder.append("\u0000");
            return builder.toString();
        }

        public String toString() {
            return "Message {command='" + this.command + "', headers=" + this.headers + ", payload='" + this.payload + "'}";
        }
    }

    public static class Header {
        public static final String VERSION = "accept-version";
        public static final String HEART_BEAT = "heart-beat";
        public static final String DESTINATION = "destination";
        public static final String MESSAGE_ID = "message-id";
        public static final String ID = "id";
        public static final String SUBSCRIPTION = "subscription";
        public static final String ACK = "ack";
        private final String key;
        private final String value;

        public Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + ':' + this.value;
        }
    }
}

