/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.io.IOException;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.magic.AbsCallback;
import org.aoju.bus.http.magic.HttpRequest;
import org.aoju.bus.http.magic.HttpResponse;
import org.aoju.bus.http.magic.HttpxStat;

public class RequestCall {
    private Httpd httpd;
    private HttpRequest httpRequest;
    private Request request;
    private NewCall newCall;

    public RequestCall(HttpRequest request, Httpd httpd) {
        this.httpRequest = request;
        this.httpd = httpd;
    }

    public NewCall buildCall(AbsCallback absCallback) {
        this.request = this.createRequest(absCallback);
        this.newCall = this.httpd.newCall(this.request);
        return this.newCall;
    }

    private Request createRequest(AbsCallback absCallback) {
        return this.httpRequest.createRequest(absCallback);
    }

    public HttpResponse execute() throws Exception {
        this.buildCall(null);
        try {
            HttpResponse rsp = new HttpResponse(this.newCall.execute());
            if (rsp.isSuccessful()) {
                HttpxStat.onReqSuccess();
            } else {
                HttpxStat.onReqFailure(this.newCall.request().url().toString(), null);
            }
            return rsp;
        }
        catch (Exception e) {
            HttpxStat.onReqFailure(this.newCall.request().url().toString(), e);
            throw e;
        }
    }

    public void executeAsync(AbsCallback absCallback) {
        this.buildCall(absCallback);
        this.execute(this, absCallback);
    }

    private void execute(RequestCall requestCall, AbsCallback absCallback) {
        final AbsCallback finalAbsCallback = absCallback;
        final String id = requestCall.getHttpRequest().getId();
        requestCall.getNewCall().enqueue(new Callback(){

            @Override
            public void onFailure(NewCall newCall, IOException e) {
                HttpxStat.onReqFailure(newCall.request().url().toString(), e);
                if (null != finalAbsCallback) {
                    finalAbsCallback.onFailure(newCall, e, id);
                }
            }

            @Override
            public void onResponse(NewCall newCall, Response response) {
                HttpxStat.onReqSuccess();
                if (null != finalAbsCallback) {
                    finalAbsCallback.onResponse(newCall, new HttpResponse(response), id);
                }
            }
        });
    }

    public NewCall getNewCall() {
        return this.newCall;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void cancel() {
        if (null != this.newCall) {
            this.newCall.cancel();
        }
    }
}

