/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.image.Args;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Efforts;
import org.aoju.bus.image.Node;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.TransferCapability;
import org.aoju.bus.image.plugin.StoreSCP;
import org.aoju.bus.logger.Logger;

public class Centre {
    public Device device;
    public StoreSCP storeSCP;
    public Node node;
    public Args args;
    public Efforts efforts;
    public ExecutorService executor;
    public ScheduledExecutorService scheduledExecutor;

    public Centre(Device device) {
        this.device = Objects.requireNonNull(device);
    }

    public void start() {
        this.start(false);
    }

    public synchronized void start(boolean ... flag) {
        if (BooleanKit.or(flag)) {
            if (null == this.executor) {
                this.executor = Executors.newSingleThreadExecutor();
                this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
                this.device.setExecutor(this.executor);
                this.device.setScheduledExecutor(this.scheduledExecutor);
            }
            return;
        }
        if (this.storeSCP.getConnection().isListening()) {
            throw new InstrumentException("Cannot start a Listener because it is already running.");
        }
        if (ObjectKit.isEmpty((Object)this.storeSCP)) {
            throw new NullPointerException("The StoreSCP cannot be null.");
        }
        if (ObjectKit.isEmpty((Object)this.node)) {
            throw new NullPointerException("The node cannot be null.");
        }
        if (ObjectKit.isEmpty((Object)this.args)) {
            throw new NullPointerException("The args cannot be null.");
        }
        if (ObjectKit.isNotEmpty((Object)this.efforts)) {
            this.storeSCP.setEfforts(this.efforts);
        }
        this.storeSCP.setStatus(0);
        Connection conn = this.storeSCP.getConnection();
        if (this.args.isBindCallingAet()) {
            this.args.configureBind(this.storeSCP.getApplicationEntity(), conn, this.node);
        } else {
            this.args.configureBind(conn, this.node);
        }
        this.args.configure(conn);
        try {
            this.args.configureTLS(conn, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.storeSCP.getApplicationEntity().setAcceptedCallingAETitles(this.args.getAcceptedCallingAETitles());
        URL transferCapabilityFile = this.args.getTransferCapabilityFile();
        if (null != transferCapabilityFile) {
            this.storeSCP.loadDefaultTransferCapability(transferCapabilityFile);
        } else {
            this.storeSCP.getApplicationEntity().addTransferCapability(new TransferCapability(null, "*", TransferCapability.Role.SCP, "*"));
        }
        this.executor = Executors.newCachedThreadPool();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
        try {
            this.device = this.storeSCP.getDevice();
            this.device.setExecutor(this.executor);
            this.device.setScheduledExecutor(this.scheduledExecutor);
            this.device.bindConnections();
        }
        catch (IOException | GeneralSecurityException e) {
            this.stop();
            Logger.error(e.getMessage(), new Object[0]);
        }
    }

    public synchronized void stop() {
        if (null != this.device) {
            this.device.unbindConnections();
        }
        Builder.shutdown(this.scheduledExecutor);
        Builder.shutdown(this.executor);
        this.executor = null;
        this.scheduledExecutor = null;
    }

    public static CentreBuilder builder() {
        return new CentreBuilder();
    }

    public Centre() {
    }

    public Centre(Device device, StoreSCP storeSCP, Node node, Args args, Efforts efforts, ExecutorService executor, ScheduledExecutorService scheduledExecutor) {
        this.device = device;
        this.storeSCP = storeSCP;
        this.node = node;
        this.args = args;
        this.efforts = efforts;
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
    }

    public static class CentreBuilder {
        private Device device;
        private StoreSCP storeSCP;
        private Node node;
        private Args args;
        private Efforts efforts;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;

        CentreBuilder() {
        }

        public CentreBuilder device(Device device) {
            this.device = device;
            return this;
        }

        public CentreBuilder storeSCP(StoreSCP storeSCP) {
            this.storeSCP = storeSCP;
            return this;
        }

        public CentreBuilder node(Node node) {
            this.node = node;
            return this;
        }

        public CentreBuilder args(Args args) {
            this.args = args;
            return this;
        }

        public CentreBuilder efforts(Efforts efforts) {
            this.efforts = efforts;
            return this;
        }

        public CentreBuilder executor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public CentreBuilder scheduledExecutor(ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
            return this;
        }

        public Centre build() {
            return new Centre(this.device, this.storeSCP, this.node, this.args, this.efforts, this.executor, this.scheduledExecutor);
        }

        public String toString() {
            return "Centre.CentreBuilder(device=" + this.device + ", storeSCP=" + this.storeSCP + ", node=" + this.node + ", args=" + this.args + ", efforts=" + this.efforts + ", executor=" + this.executor + ", scheduledExecutor=" + this.scheduledExecutor + ")";
        }
    }
}

