/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.aoju.bus.core.toolkit.StreamKit;
import org.aoju.bus.image.galaxy.Property;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.data.Value;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;

public class BulkData
implements Value {
    private final String uuid;
    private final boolean bigEndian;
    private String uri;
    private int uriPathEnd;
    private long offset = 0L;
    private int length = -1;

    public BulkData(String uuid, String uri, boolean bigEndian) {
        this.uuid = uuid;
        this.setURI(uri);
        this.bigEndian = bigEndian;
    }

    public BulkData(String uri, long offset, int length, boolean bigEndian) {
        this.uuid = null;
        this.uriPathEnd = uri.length();
        this.uri = uri + "?offset=" + offset + "&length=" + length;
        this.offset = offset;
        this.length = length;
        this.bigEndian = bigEndian;
    }

    public static Value deserializeFrom(ObjectInputStream ois) throws IOException {
        return new BulkData(Property.maskEmpty(ois.readUTF(), null), Property.maskEmpty(ois.readUTF(), null), ois.readBoolean());
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
        this.uriPathEnd = uri.length();
        this.offset = 0L;
        this.length = -1;
        int pathEnd = uri.indexOf(63);
        if (pathEnd < 0) {
            return;
        }
        this.uriPathEnd = pathEnd;
        if (!uri.startsWith("?offset=", pathEnd)) {
            return;
        }
        int offsetEnd = uri.indexOf("&length=", pathEnd + 8);
        if (offsetEnd < 0) {
            return;
        }
        try {
            this.offset = Integer.parseInt(uri.substring(pathEnd + 8, offsetEnd));
            this.length = Integer.parseInt(uri.substring(offsetEnd + 8));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean bigEndian() {
        return this.bigEndian;
    }

    public int length() {
        return this.length;
    }

    public long offset() {
        return this.offset;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    public String toString() {
        return "BulkData[uuid=" + this.uuid + ", uri=" + this.uri + ", bigEndian=" + this.bigEndian + "]";
    }

    public File getFile() {
        try {
            return new File(new URI(this.uriWithoutOffsetAndLength()));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("uri: " + this.uri);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("uri: " + this.uri);
        }
    }

    public String uriWithoutOffsetAndLength() {
        if (null == this.uri) {
            throw new IllegalStateException("uri: null");
        }
        return this.uri.substring(0, this.uriPathEnd);
    }

    public InputStream openStream() throws IOException {
        if (null == this.uri) {
            throw new IllegalStateException("uri: null");
        }
        if (!this.uri.startsWith("file:")) {
            return new URL(this.uri).openStream();
        }
        FileInputStream in = new FileInputStream(this.getFile());
        StreamKit.skipFully(in, this.offset);
        return in;
    }

    @Override
    public int calcLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        return this.length + 1 & 0xFFFFFFFE;
    }

    @Override
    public int getEncodedLength(ImageEncodingOptions encOpts, boolean explicitVR, VR vr) {
        return this.length == -1 ? -1 : this.length + 1 & 0xFFFFFFFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toBytes(VR vr, boolean bigEndian) throws IOException {
        if (this.length == -1) {
            throw new UnsupportedOperationException();
        }
        if (this.length == 0) {
            return new byte[0];
        }
        try (InputStream in = this.openStream();){
            byte[] b = new byte[this.length];
            StreamKit.readFully(in, b, 0, b.length);
            if (this.bigEndian != bigEndian) {
                vr.toggleEndian(b, false);
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(ImageOutputStream out, VR vr) throws IOException {
        try (InputStream in = this.openStream();){
            if (this.bigEndian != out.isBigEndian()) {
                StreamKit.copy(in, (OutputStream)out, this.length, vr.numEndianBytes());
            } else {
                StreamKit.copy(in, (OutputStream)out, this.length);
            }
            if ((this.length & 1) != 0) {
                out.write(vr.paddingByte());
            }
        }
    }

    public void serializeTo(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(Property.maskNull(this.uuid, ""));
        oos.writeUTF(Property.maskNull(this.uri, ""));
        oos.writeBoolean(this.bigEndian);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BulkData other = (BulkData)obj;
        if (this.bigEndian != other.bigEndian) {
            return false;
        }
        if (null == this.uri ? null != other.uri : !this.uri.equals(other.uri)) {
            return false;
        }
        if (null == this.uuid) {
            return null == other.uuid;
        }
        return this.uuid.equals(other.uuid);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bigEndian ? 1231 : 1237);
        result = 31 * result + (null == this.uri ? 0 : this.uri.hashCode());
        result = 31 * result + (null == this.uuid ? 0 : this.uuid.hashCode());
        return result;
    }

    public long getSegmentEnd() {
        if (this.length == -1) {
            return -1L;
        }
        return this.offset() + this.longLength();
    }

    public long longLength() {
        if (this.length == -1) {
            return -1L;
        }
        return (long)this.length & 0xFFFFFFFFL;
    }

    public void setOffset(long offset) {
        this.offset = offset;
        this.uri = this.uri.substring(0, this.uriPathEnd) + "?offset=" + offset + "&length=" + this.length;
    }

    public void setLength(long longLength) {
        if (longLength < -1L || longLength > 0xFFFFFFF0L) {
            throw new IllegalArgumentException("BulkData length limited to -1..2^32-16 but was " + longLength);
        }
        this.length = (int)longLength;
        this.uri = this.uri.substring(0, this.uriPathEnd) + "?offset=" + this.offset + "&length=" + this.length;
    }
}

