/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MLLPInputStream
extends BufferedInputStream {
    private static final int SOM = 11;
    private static final int EOM1 = 28;
    private static final int EOM2 = 13;
    private final ByteArrayOutputStream readBuffer = new ByteArrayOutputStream();
    private boolean eom = true;

    public MLLPInputStream(InputStream in) {
        super(in);
    }

    public MLLPInputStream(InputStream in, int size) {
        super(in, size);
    }

    public synchronized boolean hasMoreInput() throws IOException {
        if (!this.eom) {
            throw new IllegalStateException();
        }
        int b = super.read();
        if (b == -1) {
            return false;
        }
        if (b != 11) {
            throw new IOException("Missing Start Block character");
        }
        this.eom = false;
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.eom) {
            return -1;
        }
        int b = super.read();
        if (b == -1) {
            throw new EOFException();
        }
        if (b != 28) {
            return b;
        }
        this.eom();
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (null == b) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.eom) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        if (this.read() == -1) {
            return -1;
        }
        int rlen = Math.min(this.count - this.pos, len - 1);
        int remaining = this.remaining(this.pos + rlen);
        if (remaining == -1) {
            System.arraycopy(this.buf, this.pos - 1, b, off, rlen + 1);
            this.pos += rlen;
            return rlen + 1;
        }
        System.arraycopy(this.buf, this.pos - 1, b, off, remaining + 1);
        this.pos += remaining + 1;
        this.eom();
        return remaining + 1;
    }

    public synchronized int copyTo(OutputStream out) throws IOException {
        int remaining;
        if (this.eom) {
            throw new IllegalStateException();
        }
        int totlen = 0;
        int leftover = 0;
        while ((remaining = this.remaining(this.count)) == -1) {
            int avail = this.count - this.pos;
            out.write(this.buf, this.pos - leftover, avail + leftover);
            totlen += avail + leftover;
            this.pos = this.count;
            if (this.read() == -1) {
                return totlen;
            }
            leftover = 1;
        }
        out.write(this.buf, this.pos - leftover, remaining + leftover);
        this.pos += remaining + 1;
        this.eom();
        return totlen += remaining + leftover;
    }

    public synchronized byte[] readMessage() throws IOException {
        if (!this.hasMoreInput()) {
            return null;
        }
        this.readBuffer.reset();
        this.copyTo(this.readBuffer);
        return this.readBuffer.toByteArray();
    }

    private void eom() throws IOException {
        int b = super.read();
        if (b != 13) {
            throw new IOException("1CH followed by " + Integer.toHexString(b & 0xFF) + "H instead by 0DH");
        }
        this.eom = true;
    }

    private int remaining(int count) {
        for (int i = this.pos; i < count; ++i) {
            if (this.buf[i] != 28) continue;
            return i - this.pos;
        }
        return -1;
    }
}

