/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.service;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Commands;
import org.aoju.bus.image.metric.ImageException;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.service.Query;

public class BasicQuery
implements Query {
    protected final Association as;
    protected final Presentation pc;
    protected final Attributes rq;
    protected final Attributes keys;
    protected volatile boolean canceled;
    protected boolean optionalKeysNotSupported = false;

    public BasicQuery(Association as, Presentation pc, Attributes rq, Attributes keys) {
        this.as = as;
        this.pc = pc;
        this.rq = rq;
        this.keys = keys;
    }

    public boolean isOptionalKeysNotSupported() {
        return this.optionalKeysNotSupported;
    }

    public void setOptionalKeysNotSupported(boolean optionalKeysNotSupported) {
        this.optionalKeysNotSupported = optionalKeysNotSupported;
    }

    @Override
    public void onCancelRQ(Association as) {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int msgId = this.rq.getInt(272, -1);
            this.as.addCancelRQHandler(msgId, this);
            try {
                while (!this.canceled && this.hasMoreMatches()) {
                    Attributes match = this.adjust(this.nextMatch());
                    if (null == match) continue;
                    int status = this.optionalKeysNotSupported ? 65281 : 65280;
                    this.as.writeDimseRSP(this.pc, Commands.mkCFindRSP(this.rq, status), match);
                }
                int status = this.canceled ? 65024 : 0;
                this.as.writeDimseRSP(this.pc, Commands.mkCFindRSP(this.rq, status));
            }
            catch (ImageException e) {
                Attributes rsp = e.mkRSP(32800, msgId);
                this.as.writeDimseRSP(this.pc, rsp, e.getDataset());
            }
            finally {
                this.as.removeCancelRQHandler(msgId);
                this.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void close() {
    }

    protected Attributes nextMatch() throws ImageException {
        throw new NoSuchElementException();
    }

    protected boolean hasMoreMatches() throws ImageException {
        return false;
    }

    protected Attributes adjust(Attributes match) {
        String[] ss;
        if (null == match) {
            return null;
        }
        Attributes filtered = new Attributes(match.size());
        if (!this.keys.contains(524293) && null != (ss = match.getStrings(524293))) {
            filtered.setString(524293, VR.CS, ss);
        }
        filtered.addSelected(match, this.keys);
        return filtered;
    }
}

