/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.entity;

import org.aoju.bus.mapper.criteria.Assert;
import org.aoju.bus.mapper.entity.EntityField;
import org.aoju.bus.mapper.entity.EntityTable;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class EntityColumn {
    private EntityTable table;
    private String property;
    private String column;
    private Class<?> javaType;
    private JdbcType jdbcType;
    private Class<? extends TypeHandler<?>> typeHandler;
    private String sequenceName;
    private boolean id = false;
    private boolean uuid = false;
    private boolean identity = false;
    private String generator;
    private String orderBy;
    private boolean insertable = true;
    private boolean updatable = true;
    private EntityField entityField;

    public EntityColumn() {
    }

    public EntityColumn(EntityTable table) {
        this.table = table;
    }

    public String getColumnEqualsHolder(String entityName) {
        return this.column + " = " + this.getColumnHolder(entityName);
    }

    public String getColumnHolder(String entityName) {
        return this.getColumnHolder(entityName, null);
    }

    public String getColumnHolder(String entityName, String suffix) {
        return this.getColumnHolder(entityName, null, null);
    }

    public String getColumnHolderWithComma(String entityName, String suffix) {
        return this.getColumnHolder(entityName, suffix, ",");
    }

    public String getColumnHolder(String entityName, String suffix, String separator) {
        StringBuffer sb = new StringBuffer("#{");
        if (Assert.isNotEmpty(entityName)) {
            sb.append(entityName);
            sb.append(".");
        }
        sb.append(this.property);
        if (Assert.isNotEmpty(suffix)) {
            sb.append(suffix);
        }
        if (null != this.jdbcType) {
            sb.append(",jdbcType=");
            sb.append(this.jdbcType.toString());
        } else if (null != this.typeHandler) {
            sb.append(",typeHandler=");
            sb.append(this.typeHandler.getCanonicalName());
        } else if (!this.javaType.isArray()) {
            sb.append(",javaType=");
            sb.append(this.javaType.getCanonicalName());
        }
        sb.append("}");
        if (Assert.isNotEmpty(separator)) {
            sb.append(separator);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        EntityColumn that = (EntityColumn)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.uuid != that.uuid) {
            return false;
        }
        if (this.identity != that.identity) {
            return false;
        }
        if (null != this.table ? !this.table.equals(that.table) : null != that.table) {
            return false;
        }
        if (null != this.property ? !this.property.equals(that.property) : null != that.property) {
            return false;
        }
        if (null != this.column ? !this.column.equals(that.column) : null != that.column) {
            return false;
        }
        if (null != this.javaType ? !this.javaType.equals(that.javaType) : null != that.javaType) {
            return false;
        }
        if (this.jdbcType != that.jdbcType) {
            return false;
        }
        if (null != this.typeHandler ? !this.typeHandler.equals(that.typeHandler) : null != that.typeHandler) {
            return false;
        }
        if (null != this.sequenceName ? !this.sequenceName.equals(that.sequenceName) : null != that.sequenceName) {
            return false;
        }
        if (null != this.generator ? !this.generator.equals(that.generator) : null != that.generator) {
            return false;
        }
        return !(null == this.orderBy ? null != that.orderBy : !this.orderBy.equals(that.orderBy));
    }

    public int hashCode() {
        int result = null != this.table ? this.table.hashCode() : 0;
        result = 31 * result + (null != this.property ? this.property.hashCode() : 0);
        result = 31 * result + (null != this.column ? this.column.hashCode() : 0);
        result = 31 * result + (null != this.javaType ? this.javaType.hashCode() : 0);
        result = 31 * result + (null != this.jdbcType ? this.jdbcType.hashCode() : 0);
        result = 31 * result + (null != this.typeHandler ? this.typeHandler.hashCode() : 0);
        result = 31 * result + (null != this.sequenceName ? this.sequenceName.hashCode() : 0);
        result = 31 * result + (this.id ? 1 : 0);
        result = 31 * result + (this.uuid ? 1 : 0);
        result = 31 * result + (this.identity ? 1 : 0);
        result = 31 * result + (null != this.generator ? this.generator.hashCode() : 0);
        result = 31 * result + (null != this.orderBy ? this.orderBy.hashCode() : 0);
        return result;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getColumnEqualsHolder() {
        return this.getColumnEqualsHolder(null);
    }

    public String getColumnHolder() {
        return this.getColumnHolder(null);
    }

    public EntityField getEntityField() {
        return this.entityField;
    }

    public void setEntityField(EntityField entityField) {
        this.entityField = entityField;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public EntityTable getTable() {
        return this.table;
    }

    public void setTable(EntityTable table) {
        this.table = table;
    }

    public Class<? extends TypeHandler<?>> getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        this.typeHandler = typeHandler;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public boolean isUuid() {
        return this.uuid;
    }

    public void setUuid(boolean uuid) {
        this.uuid = uuid;
    }
}

