/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class DingTalkProvider
extends AbstractProvider {
    public DingTalkProvider(Context context) {
        super(context, Registry.DINGTALK);
    }

    public DingTalkProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.DINGTALK, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return AccToken.builder().accessCode(callback.getCode()).build();
    }

    @Override
    public Object getUserInfo(AccToken accToken) {
        String code = accToken.getAccessCode();
        JSONObject param = new JSONObject();
        param.put("tmp_auth_code", (Object)code);
        String response = Httpx.post(this.userInfoUrl(accToken), param.toJSONString(), "application/json");
        JSONObject object = JSON.parseObject((String)response);
        if (object.getIntValue("errcode") != 0) {
            throw new AuthorizedException(object.getString("errmsg"));
        }
        object = object.getJSONObject("user_info");
        AccToken token = AccToken.builder().openId(object.getString("openid")).unionId(object.getString("unionid")).build();
        return Property.builder().rawJson(object).uuid(object.getString("unionid")).nickname(object.getString("nick")).username(object.getString("nick")).gender(Normal.Gender.UNKNOWN).source(this.source.toString()).token(token).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("appid", this.context.getAppKey()).queryParam("scope", "snsapi_login").queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        String timestamp = System.currentTimeMillis() + "";
        byte[] signData = DingTalkProvider.sign(this.context.getAppSecret().getBytes(Charset.UTF_8), timestamp.getBytes(Charset.UTF_8), Algorithm.HmacSHA256.getValue());
        String urlEncodeSignature = UriKit.encode(new String(Base64.encode(signData, false)));
        return Builder.fromUrl(this.source.userInfo()).queryParam("signature", urlEncodeSignature).queryParam("timestamp", timestamp).queryParam("accessKey", this.context.getAppKey()).build();
    }
}

