/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class XmlyProvider
extends AbstractProvider {
    public XmlyProvider(Context context) {
        super(context, Registry.XMLY);
    }

    public XmlyProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.XMLY, extendCache);
    }

    public static String sign(Map<String, String> params, String clientSecret) {
        TreeMap<String, Object> map = new TreeMap<String, Object>(params);
        String baseStr = Base64.encode(Builder.parseMapToString(map, false));
        byte[] sign = XmlyProvider.sign(clientSecret.getBytes(Charset.UTF_8), baseStr.getBytes(Charset.UTF_8), Algorithm.HmacSHA1.getValue());
        StringBuilder builder = null;
        try {
            byte[] byteData;
            builder = new StringBuilder();
            MessageDigest md5 = MessageDigest.getInstance(Algorithm.MD5.getValue());
            md5.update(sign);
            for (byte byteDatum : byteData = md5.digest()) {
                builder.append(Integer.toString((byteDatum & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == builder ? "" : builder.toString();
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("code", callback.getCode());
        params.put("client_id", this.context.getAppKey());
        params.put("client_secret", this.context.getAppSecret());
        params.put("device_id", this.context.getDeviceId());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.context.getRedirectUri());
        String response = Httpx.post(this.source.accessToken(), params);
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).expireIn(accessTokenObject.getIntValue("expires_in")).uid(accessTokenObject.getString("uid")).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("client_os_type", "3").queryParam("device_id", this.context.getDeviceId()).build();
    }

    @Override
    public Property getUserInfo(AccToken authToken) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("app_key", this.context.getAppKey());
        params.put("client_os_type", Optional.ofNullable(this.context.getClientOsType()).orElse(3).toString());
        params.put("device_id", this.context.getDeviceId());
        params.put("pack_id", this.context.getPackId());
        params.put("access_token", authToken.getAccessToken());
        params.put("sig", XmlyProvider.sign(params, this.context.getAppSecret()));
        String response = Httpx.post(this.source.userInfo(), null, params);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return Property.builder().uuid(object.getString("id")).nickname(object.getString("nickname")).avatar(object.getString("avatar_url")).rawJson(object).source(this.source.toString()).token(authToken).gender(Normal.Gender.UNKNOWN).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"errcode")) {
            throw new AuthorizedException(object.getString("error_no"), object.getString("error_desc"));
        }
    }
}

