/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import java.io.OutputStream;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.office.support.excel.ExcelWriter;
import org.aoju.bus.office.support.excel.WorksKit;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class BigExcelWriter
extends ExcelWriter {
    public static final int DEFAULT_WINDOW_SIZE = 100;
    private boolean isFlushed;

    public BigExcelWriter() {
        this(100);
    }

    public BigExcelWriter(int rowAccessWindowSize) {
        this(WorksKit.createSXSSFBook(rowAccessWindowSize), null);
    }

    public BigExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public BigExcelWriter(int rowAccessWindowSize, String sheetName) {
        this(WorksKit.createSXSSFBook(rowAccessWindowSize), sheetName);
    }

    public BigExcelWriter(String destFilePath, String sheetName) {
        this(FileKit.file(destFilePath), sheetName);
    }

    public BigExcelWriter(File destFile) {
        this(destFile, null);
    }

    public BigExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? WorksKit.createSXSSFBook(destFile) : WorksKit.createSXSSFBook(), sheetName);
        this.destFile = destFile;
    }

    public BigExcelWriter(SXSSFWorkbook workbook, String sheetName) {
        this(WorksKit.getOrCreateSheet((Workbook)workbook, sheetName));
    }

    public BigExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public BigExcelWriter autoSizeColumn(int columnIndex) {
        SXSSFSheet sheet = (SXSSFSheet)this.sheet;
        sheet.trackColumnForAutoSizing(columnIndex);
        super.autoSizeColumn(columnIndex);
        sheet.untrackColumnForAutoSizing(columnIndex);
        return this;
    }

    @Override
    public BigExcelWriter autoSizeColumnAll() {
        SXSSFSheet sheet = (SXSSFSheet)this.sheet;
        sheet.trackAllColumnsForAutoSizing();
        super.autoSizeColumnAll();
        sheet.untrackAllColumnsForAutoSizing();
        return this;
    }

    @Override
    public ExcelWriter flush(OutputStream out, boolean isCloseOut) {
        if (!this.isFlushed) {
            this.isFlushed = true;
            return super.flush(out, isCloseOut);
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile && !this.isFlushed) {
            this.flush();
        }
        ((SXSSFWorkbook)this.workbook).dispose();
        super.closeWithoutFlush();
    }
}

