/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import java.io.InputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.BigExcelWriter;
import org.aoju.bus.office.support.excel.ExcelFileKit;
import org.aoju.bus.office.support.excel.ExcelReader;
import org.aoju.bus.office.support.excel.ExcelSaxKit;
import org.aoju.bus.office.support.excel.ExcelWriter;
import org.aoju.bus.office.support.excel.cell.CellLocation;
import org.aoju.bus.office.support.excel.sax.ExcelSaxReader;
import org.aoju.bus.office.support.excel.sax.RowHandler;

public class ExcelKit {
    public static void readBySax(String path, int rid, RowHandler rowHandler) {
        ExcelKit.readBySax(FileKit.file(path), rid, rowHandler);
    }

    public static void readBySax(String path, String idOrRid, RowHandler rowHandler) {
        ExcelKit.readBySax(FileKit.file(path), idOrRid, rowHandler);
    }

    public static void readBySax(File file, int rid, RowHandler rowHandler) {
        ExcelSaxReader<?> reader = ExcelSaxKit.createSaxReader(ExcelFileKit.isXlsx(file), rowHandler);
        reader.read(file, rid);
    }

    public static void readBySax(File file, String idOrRid, RowHandler rowHandler) {
        ExcelSaxReader<?> reader = ExcelSaxKit.createSaxReader(ExcelFileKit.isXlsx(file), rowHandler);
        reader.read(file, idOrRid);
    }

    public static void readBySax(InputStream in, int rid, RowHandler rowHandler) {
        in = IoKit.toMarkSupportStream(in);
        ExcelSaxReader<?> reader = ExcelSaxKit.createSaxReader(ExcelFileKit.isXlsx(in), rowHandler);
        reader.read(in, rid);
    }

    public static void readBySax(InputStream in, String idOrRid, RowHandler rowHandler) {
        in = IoKit.toMarkSupportStream(in);
        ExcelSaxReader<?> reader = ExcelSaxKit.createSaxReader(ExcelFileKit.isXlsx(in), rowHandler);
        reader.read(in, idOrRid);
    }

    public static ExcelReader getReader(String bookFilePath) {
        return ExcelKit.getReader(bookFilePath, 0);
    }

    public static ExcelReader getReader(File bookFile) {
        return ExcelKit.getReader(bookFile, 0);
    }

    public static ExcelReader getReader(String bookFilePath, int sheetIndex) {
        try {
            return new ExcelReader(bookFilePath, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelReader getReader(File bookFile, int sheetIndex) {
        try {
            return new ExcelReader(bookFile, sheetIndex);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelReader getReader(File bookFile, String sheetName) {
        try {
            return new ExcelReader(bookFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelReader getReader(InputStream bookStream) {
        return ExcelKit.getReader(bookStream, 0, true);
    }

    public static ExcelReader getReader(InputStream bookStream, boolean closeAfterRead) {
        try {
            return ExcelKit.getReader(bookStream, 0, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex) {
        try {
            return new ExcelReader(bookStream, sheetIndex, true);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, int sheetIndex, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetIndex, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName) {
        try {
            return new ExcelReader(bookStream, sheetName, true);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelReader getReader(InputStream bookStream, String sheetName, boolean closeAfterRead) {
        try {
            return new ExcelReader(bookStream, sheetName, closeAfterRead);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getWriter() {
        try {
            return new ExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getWriter(boolean isXlsx) {
        try {
            return new ExcelWriter(isXlsx);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getWriter(String destFilePath) {
        try {
            return new ExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getWriter(File destFile) {
        try {
            return new ExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getWriter(String destFilePath, String sheetName) {
        try {
            return new ExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getWriter(File destFile, String sheetName) {
        try {
            return new ExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getBigWriter() {
        try {
            return new BigExcelWriter();
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static ExcelWriter getBigWriter(int rowAccessWindowSize) {
        try {
            return new BigExcelWriter(rowAccessWindowSize);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath) {
        try {
            return new BigExcelWriter(destFilePath);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static BigExcelWriter getBigWriter(File destFile) {
        try {
            return new BigExcelWriter(destFile);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static BigExcelWriter getBigWriter(String destFilePath, String sheetName) {
        try {
            return new BigExcelWriter(destFilePath, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static BigExcelWriter getBigWriter(File destFile, String sheetName) {
        try {
            return new BigExcelWriter(destFile, sheetName);
        }
        catch (NoClassDefFoundError e) {
            throw new InstrumentException("You need to add dependency of 'poi-ooxml' to your project, and version >= 4.1.2");
        }
    }

    public static String indexToColName(int index) {
        int remainder;
        if (index < 0) {
            return null;
        }
        StringBuilder colName = StringKit.builder();
        do {
            if (colName.length() > 0) {
                --index;
            }
            remainder = index % 26;
            colName.append((char)(remainder + 65));
        } while ((index = (index - remainder) / 26) > 0);
        return colName.reverse().toString();
    }

    public static int colNameToIndex(String colName) {
        char c;
        int length = colName.length();
        int index = -1;
        for (int i = 0; i < length && !Character.isDigit(c = Character.toUpperCase(colName.charAt(i))); ++i) {
            index = (index + 1) * 26 + c - 65;
        }
        return index;
    }

    public static CellLocation toLocation(String locationRef) {
        int x = ExcelKit.colNameToIndex(locationRef);
        int y = PatternKit.getFirstNumber(locationRef) - 1;
        return new CellLocation(x, y);
    }
}

