/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.io.FileNotFoundException;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.mapper.MybatisPluginBuilder;
import org.aoju.bus.starter.mapper.MybatisProperties;
import org.aoju.bus.starter.sensitive.SensitiveProperties;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@EnableConfigurationProperties(value={MybatisProperties.class})
public class MybatisConfiguration {
    @Autowired
    MybatisProperties mybatisProperties;
    @Autowired(required=false)
    SensitiveProperties sensitiveProperties;

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) {
        try {
            SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
            bean.setDataSource(dataSource);
            if (StringKit.isNotBlank(this.mybatisProperties.getTypeAliasesPackage())) {
                bean.setTypeAliasesPackage(this.mybatisProperties.getTypeAliasesPackage());
            }
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            bean.setPlugins(MybatisPluginBuilder.build(this.mybatisProperties, this.sensitiveProperties));
            try {
                bean.setMapperLocations(resolver.getResources(this.mybatisProperties.getXmlLocation()));
            }
            catch (FileNotFoundException e) {
                Logger.warn(e.getMessage(), new Object[0]);
            }
            return bean.getObject();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    @Bean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

