/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.mapper.AbstractSqlParserHandler;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=ParameterHandler.class, method="setParameters", args={PreparedStatement.class})})
public class RecordTimeHandler
extends AbstractSqlParserHandler
implements Interceptor {
    private static String createDateColumnName;
    private static String updateDateColumnName;
    private static List<String> ignoreTableList;

    public Object intercept(Invocation invocation) throws Throwable {
        if ("prepare".equals(invocation.getMethod().getName())) {
            Update update;
            Table table;
            StatementHandler handler = (StatementHandler)RecordTimeHandler.realTarget(invocation.getTarget());
            MetaObject metaObject = SystemMetaObject.forObject((Object)handler);
            MappedStatement ms = RecordTimeHandler.getMappedStatement(metaObject);
            String sql = metaObject.getValue("delegate.boundSql.sql").toString();
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            SqlCommandType sqlCommandType = ms.getSqlCommandType();
            String currentDate = StringKit.toString(DateKit.timestamp());
            if (SqlCommandType.INSERT == sqlCommandType) {
                Insert insert = (Insert)statement;
                if (!this.matchesIgnoreTables(insert.getTable().getName())) {
                    boolean isContainsCreateDateColumn = false;
                    boolean isContainsModifyDateColumn = false;
                    int createDateColumnIndex = 0;
                    int modifyDateColumnIndex = 0;
                    for (int i = 0; i < insert.getColumns().size(); ++i) {
                        Column column = (Column)insert.getColumns().get(i);
                        if (column.getColumnName().equals(createDateColumnName)) {
                            isContainsCreateDateColumn = true;
                            createDateColumnIndex = i;
                        }
                        if (!column.getColumnName().equals(updateDateColumnName)) continue;
                        isContainsModifyDateColumn = true;
                        modifyDateColumnIndex = i;
                    }
                    if (isContainsCreateDateColumn) {
                        this.intoValueWithIndex(createDateColumnIndex, currentDate, insert);
                    } else {
                        this.intoValue(createDateColumnName, currentDate, insert);
                    }
                    if (isContainsModifyDateColumn) {
                        this.intoValueWithIndex(modifyDateColumnIndex, currentDate, insert);
                    } else {
                        this.intoValue(updateDateColumnName, currentDate, insert);
                    }
                    Logger.debug("currentDate insert sql: {}", insert.toString());
                    metaObject.setValue("delegate.boundSql.sql", (Object)insert.toString());
                }
            } else if (SqlCommandType.UPDATE == sqlCommandType && !this.matchesIgnoreTables((table = (update = (Update)statement).getTable()).getName())) {
                boolean isContainsModifyDateColumn = false;
                int modifyDateColumnIndex = 0;
                for (int i = 0; i < update.getColumns().size(); ++i) {
                    Column column = (Column)update.getColumns().get(i);
                    if (!column.getColumnName().equals(updateDateColumnName)) continue;
                    isContainsModifyDateColumn = true;
                    modifyDateColumnIndex = i;
                }
                if (isContainsModifyDateColumn) {
                    this.updateValueWithIndex(modifyDateColumnIndex, currentDate, update);
                } else {
                    this.updateValue(updateDateColumnName, currentDate, update);
                }
                Logger.debug("Intercept update sql: {}", update.toString());
                metaObject.setValue("delegate.boundSql.sql", (Object)update.toString());
            }
        } else if ("setParameters".equals(invocation.getMethod().getName())) {
            Update update;
            Table table;
            ParameterHandler handler = (ParameterHandler)RecordTimeHandler.realTarget(invocation.getTarget());
            MetaObject metaObject = SystemMetaObject.forObject((Object)handler);
            MappedStatement ms = (MappedStatement)metaObject.getValue("mappedStatement");
            SqlCommandType sqlCommandType = ms.getSqlCommandType();
            BoundSql boundSql = (BoundSql)metaObject.getValue("boundSql");
            Statement statement = CCJSqlParserUtil.parse((String)boundSql.getSql());
            if (SqlCommandType.INSERT == sqlCommandType) {
                Insert insert = (Insert)statement;
                if (!this.matchesIgnoreTables(insert.getTable().getName())) {
                    this.handleParameterMapping(boundSql);
                }
            } else if (SqlCommandType.UPDATE == sqlCommandType && !this.matchesIgnoreTables((table = (update = (Update)statement).getTable()).getName())) {
                this.handleParameterMapping(boundSql);
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        createDateColumnName = properties.getProperty("createDateColumnName", "created");
        updateDateColumnName = properties.getProperty("updateDateColumnName", "modified");
        String ignoreTable = properties.getProperty("ignoreTables", "");
        if (ignoreTable.length() > 0) {
            String[] tables = ignoreTable.split(",");
            ignoreTableList = Arrays.asList(tables);
        } else {
            ignoreTableList = Collections.emptyList();
        }
    }

    private void handleParameterMapping(BoundSql boundSql) {
        List parameterMappingList = boundSql.getParameterMappings();
        Iterator it = parameterMappingList.iterator();
        String camelCaseCreateDateProperty = StringKit.toCamelCase(createDateColumnName);
        String camelCaseUpdateDateProperty = StringKit.toCamelCase(updateDateColumnName);
        while (it.hasNext()) {
            ParameterMapping pm = (ParameterMapping)it.next();
            if (pm.getProperty().equals(camelCaseCreateDateProperty)) {
                Logger.debug("\u539f\u59cbSql\u8bed\u53e5\u5df2\u5305\u542b\u81ea\u52a8\u6dfb\u52a0\u7684\u5217: {}", createDateColumnName);
                it.remove();
            }
            if (!pm.getProperty().equals(camelCaseUpdateDateProperty)) continue;
            Logger.debug("\u539f\u59cbSql\u8bed\u53e5\u5df2\u5305\u542b\u81ea\u52a8\u6dfb\u52a0\u7684\u5217: {}", updateDateColumnName);
            it.remove();
        }
    }

    private boolean matchesIgnoreTables(String tableName) {
        for (String ignoreTable : ignoreTableList) {
            if (!tableName.matches(ignoreTable)) continue;
            return true;
        }
        return false;
    }

    private void updateValueWithIndex(int modifyDateColumnIndex, String currentDate, Update update) {
        update.getExpressions().set(modifyDateColumnIndex, new TimestampValue(currentDate));
    }

    private void updateValue(String updateDateColumnName, String currentDate, Update update) {
        update.getColumns().add(new Column(updateDateColumnName));
        update.getExpressions().add(new TimestampValue(currentDate));
    }

    private void intoValueWithIndex(final int index, final String columnValue, Insert insert) {
        if (null == insert.getItemsList()) {
            insert.getSelect().getSelectBody().accept((SelectVisitor)new PlainSelectVisitor(index, columnValue));
        } else {
            insert.getItemsList().accept(new ItemsListVisitor(){

                public void visit(SubSelect subSelect) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void visit(ExpressionList expressionList) {
                    expressionList.getExpressions().set(index, new TimestampValue(columnValue));
                }

                public void visit(NamedExpressionList namedExpressionList) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void visit(MultiExpressionList multiExpressionList) {
                    for (ExpressionList expressionList : multiExpressionList.getExprList()) {
                        expressionList.getExpressions().set(index, new TimestampValue(columnValue));
                    }
                }
            });
        }
    }

    private void intoValue(String columnName, final String columnValue, Insert insert) {
        insert.getColumns().add(new Column(columnName));
        if (null == insert.getItemsList()) {
            insert.getSelect().getSelectBody().accept((SelectVisitor)new PlainSelectVisitor(-1, columnValue));
        } else {
            insert.getItemsList().accept(new ItemsListVisitor(){

                public void visit(SubSelect subSelect) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void visit(ExpressionList expressionList) {
                    expressionList.getExpressions().add(new TimestampValue(columnValue));
                }

                public void visit(NamedExpressionList namedExpressionList) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void visit(MultiExpressionList multiExpressionList) {
                    for (ExpressionList expressionList : multiExpressionList.getExprList()) {
                        expressionList.getExpressions().add(new TimestampValue(columnValue));
                    }
                }
            });
        }
    }

    private class PlainSelectVisitor
    implements SelectVisitor {
        int index;
        String columnValue;

        public PlainSelectVisitor(int index, String columnValue) {
            this.index = index;
            this.columnValue = columnValue;
        }

        public void visit(PlainSelect plainSelect) {
            if (this.index != -1) {
                plainSelect.getSelectItems().set(this.index, new SelectExpressionItem((Expression)new TimestampValue(this.columnValue)));
            } else {
                plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new TimestampValue(this.columnValue)));
            }
        }

        public void visit(SetOperationList setOperationList) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void visit(WithItem withItem) {
            if (this.index != -1) {
                withItem.getWithItemList().set(this.index, new SelectExpressionItem((Expression)new TimestampValue(this.columnValue)));
            } else {
                withItem.getWithItemList().add(new SelectExpressionItem((Expression)new TimestampValue(this.columnValue)));
            }
        }

        public void visit(ValuesStatement valuesStatement) {
            if (this.index != -1) {
                valuesStatement.addExpressions(new Expression[]{new TimestampValue(this.columnValue)});
            } else {
                valuesStatement.addExpressions(new Expression[]{new TimestampValue(this.columnValue)});
            }
        }
    }
}

