/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;

public class DateConverter
extends AbstractConverter<Date> {
    private final Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value) {
        DateTime dateTime;
        if (value == null || value instanceof CharSequence && StringKit.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(DateKit.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(DateKit.date((Calendar)value));
        }
        if (value instanceof Number) {
            return this.wrap(((Number)value).longValue());
        }
        String valueStr = this.convertString(value);
        DateTime dateTime2 = dateTime = StringKit.isBlank(this.format) ? DateKit.parse(valueStr) : DateKit.parse(valueStr, this.format);
        if (null != dateTime) {
            return this.wrap(dateTime);
        }
        throw new InstrumentException("Can not convert {}:[{}] to {}", value.getClass().getName(), value, this.targetType.getName());
    }

    @Override
    public Class<Date> getTargetType() {
        return this.targetType;
    }

    private Date wrap(DateTime dateTime) {
        if (Date.class == this.targetType) {
            return dateTime;
        }
        if (DateTime.class == this.targetType) {
            return DateKit.date(dateTime);
        }
        if (java.sql.Date.class == this.targetType) {
            return dateTime.toSqlDate();
        }
        if (Time.class == this.targetType) {
            return new Time(dateTime.getTime());
        }
        if (Timestamp.class == this.targetType) {
            return dateTime.toTimestamp();
        }
        throw new UnsupportedOperationException(StringKit.format("Unsupported target Date type: {}", this.targetType.getName()));
    }

    private Date wrap(long mills) {
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (DateTime.class == this.targetType) {
            return DateKit.date(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StringKit.format("Unsupported target Date type: {}", this.targetType.getName()));
    }
}

