/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.TimeZone;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.exception.ConvertException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.XmlKit;
import org.w3c.dom.Node;

public class StringConverter
extends AbstractConverter<String> {
    private static String clobToString(Clob clob) {
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            String string = IoKit.read(reader);
            return string;
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        finally {
            IoKit.close(reader);
        }
    }

    private static String blobToString(Blob blob) {
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            String string = IoKit.read(in, Charset.UTF_8);
            return string;
        }
        catch (SQLException e) {
            throw new ConvertException(e);
        }
        finally {
            IoKit.close(in);
        }
    }

    @Override
    protected String convertInternal(Object value) {
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Node) {
            return XmlKit.toString((Node)value);
        }
        if (value instanceof Clob) {
            return StringConverter.clobToString((Clob)value);
        }
        if (value instanceof Blob) {
            return StringConverter.blobToString((Blob)value);
        }
        return this.convertString(value);
    }
}

