/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.aoju.bus.core.convert.NumberChinese;
import org.aoju.bus.core.date.Converter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.formatter.DateParser;
import org.aoju.bus.core.date.formatter.DatePrinter;
import org.aoju.bus.core.date.formatter.FastDateParser;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Formatter {
    public static String format(Date date) {
        if (null != date) {
            return Fields.NORM_DATETIME_FORMAT.format(date);
        }
        return "";
    }

    public static String format(Date date, String format) {
        TimeZone timeZone;
        if (null == date || StringKit.isBlank(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date instanceof DateTime && null != (timeZone = ((DateTime)date).getTimeZone())) {
            sdf.setTimeZone(timeZone);
        }
        return Formatter.format(date, sdf);
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return Formatter.format((TemporalAccessor)date.toInstant(), format);
    }

    public static String format(String srcDate, String srcPattern, String destPattern) {
        try {
            SimpleDateFormat srcSdf = new SimpleDateFormat(srcPattern);
            SimpleDateFormat dstSdf = new SimpleDateFormat(destPattern);
            return dstSdf.format(srcSdf.parse(srcDate));
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static long format(String date) {
        try {
            return Fields.NORM_DATETIME_FORMAT.parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static String format(long timestamp) {
        return Fields.NORM_DATETIME_FORMAT.format(new Date(timestamp));
    }

    public static String format(long timestamp, String format) {
        return new SimpleDateFormat(format).format(new Date(timestamp));
    }

    public static long format(String date, String format) {
        try {
            return new SimpleDateFormat(format).parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static String format(LocalDateTime localDateTime) {
        return Formatter.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(LocalDateTime localDateTime, String format) {
        if (null == localDateTime || StringKit.isBlank(format)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return localDateTime.format(df);
    }

    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (null == time) {
            return null;
        }
        if (null == formatter) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter.format(time);
        }
        catch (UnsupportedTemporalTypeException e) {
            if (time instanceof LocalDate && e.getMessage().contains("HourOfDay")) {
                return formatter.format(((LocalDate)time).atStartOfDay());
            }
            if (time instanceof LocalTime && e.getMessage().contains("YearOfEra")) {
                return formatter.format(((LocalTime)time).atDate(LocalDate.now()));
            }
            if (time instanceof Instant) {
                return formatter.format(((Instant)time).atZone(ZoneId.systemDefault()));
            }
            throw e;
        }
    }

    public static String format(TemporalAccessor time, String format) {
        if (null == time) {
            return null;
        }
        DateTimeFormatter formatter = StringKit.isBlank(format) ? null : DateTimeFormatter.ofPattern(format);
        return Formatter.format(time, formatter);
    }

    public static String formatDate(Date date) {
        return Formatter.formatDate(date, false);
    }

    public static String formatDate(Date date, boolean isHttp) {
        if (null == date) {
            return null;
        }
        if (isHttp) {
            return Fields.HTTP_DATETIME_FORMAT.format(date);
        }
        return Fields.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_TIME_FORMAT.format(date);
    }

    public static String format(Date date, boolean isUppercase, boolean withTime) {
        if (null == date) {
            return null;
        }
        if (!isUppercase) {
            return (withTime ? Fields.NORM_CN_DATE_TIME_FORMAT : Fields.NORM_DATE_CN_FORMAT).format(date);
        }
        return Formatter.parse(Converter.toCalendar(date), withTime);
    }

    public static String format(Calendar calendar, boolean withTime) {
        StringBuilder result = StringKit.builder();
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(NumberChinese.toChinese(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(NumberChinese.format(month, false));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(NumberChinese.format(day, false));
        result.append('\u65e5');
        if (withTime) {
            int hour = calendar.get(11);
            result.append(NumberChinese.format(hour, false));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(NumberChinese.format(minute, false));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(NumberChinese.format(second, false));
            result.append('\u79d2');
        }
        return result.toString().replace('\u96f6', '\u3007');
    }

    public static String parse(Calendar calendar, boolean withTime) {
        StringBuilder result = StringKit.builder();
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(NumberChinese.toChinese(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(NumberChinese.format(month, false));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(NumberChinese.format(day, false));
        result.append('\u65e5');
        if (withTime) {
            int hour = calendar.get(11);
            result.append(NumberChinese.format(hour, false));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(NumberChinese.format(minute, false));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(NumberChinese.format(second, false));
            result.append('\u79d2');
        }
        return result.toString().replace('\u96f6', '\u3007');
    }

    public static DateTime parse(CharSequence dateCharSequence) {
        if (StringKit.isBlank(dateCharSequence)) {
            return null;
        }
        String dateStr = dateCharSequence.toString();
        dateStr = StringKit.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (MathKit.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return Formatter.parse(dateStr, Fields.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return Formatter.parse(dateStr, Fields.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return Formatter.parse(dateStr, Fields.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return Formatter.parse(dateStr, Fields.PURE_TIME_FORMAT);
            }
        } else {
            if (PatternKit.isMatch(RegEx.TIME, (CharSequence)dateStr)) {
                return Formatter.parseTimeToday(dateStr);
            }
            if (StringKit.containsAnyIgnoreCase(dateStr, Fields.WTB)) {
                return Formatter.parseCST(dateStr);
            }
            if (StringKit.contains((CharSequence)dateStr, 'T')) {
                return Formatter.parseUTC(dateStr);
            }
        }
        if (PatternKit.isMatch(Fields.REGEX_NORM, (CharSequence)(dateStr = Formatter.normalize(dateStr)))) {
            int colonCount = CharsKit.count((CharSequence)dateStr, ":");
            switch (colonCount) {
                case 0: {
                    return Formatter.parse(dateStr, Fields.NORM_DATE_FORMAT);
                }
                case 1: {
                    return Formatter.parse(dateStr, Fields.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    int indexOfDot = StringKit.indexOf(dateStr, '.');
                    if (indexOfDot > 0) {
                        int length1 = dateStr.length();
                        if (length1 - indexOfDot > 4) {
                            dateStr = StringKit.subPre(dateStr, indexOfDot + 4);
                        }
                        return Formatter.parse(dateStr, Fields.NORM_DATETIME_MS_FORMAT);
                    }
                    return Formatter.parse(dateStr, Fields.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new InstrumentException("No format fit for date String [{}] !", dateStr);
    }

    public static LocalDateTime parse(CharSequence dateStr, String format) {
        dateStr = Formatter.normalize(dateStr);
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        try {
            return LocalDateTime.parse(dateStr, df);
        }
        catch (DateTimeParseException e) {
            return LocalDate.parse(dateStr, df).atStartOfDay();
        }
    }

    public static DateTime parse(String dateStr, DateFormat dateFormat) {
        return new DateTime((CharSequence)dateStr, dateFormat);
    }

    public static DateTime parse(String dateStr, DateParser parser) {
        return new DateTime((CharSequence)dateStr, parser);
    }

    public static DateTime parse(String dateStr, String format) {
        return new DateTime((CharSequence)dateStr, format);
    }

    public static Calendar parse(String text, String ... parsePatterns) {
        return Formatter.parseByPatterns(text, null, parsePatterns);
    }

    public static Calendar parse(String text, Locale locale, String ... parsePatterns) {
        return Formatter.parseByPatterns(text, locale, true, parsePatterns);
    }

    public static Calendar parse(String text, Locale locale, boolean lenient, String ... parsePatterns) {
        if (null == text || null == parsePatterns) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectKit.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : parsePatterns) {
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(text, pos, calendar) && pos.getIndex() == text.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new InstrumentException("Unable to parse the date: {}", text);
    }

    public static DateTime parseDate(String dateString) {
        return Formatter.parse(Formatter.normalize(dateString), Fields.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(String timeString) {
        return Formatter.parse(Formatter.normalize(timeString), Fields.NORM_TIME_FORMAT);
    }

    public static DateTime parseDateTime(String dateString) {
        return Formatter.parse(Formatter.normalize(dateString), Fields.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseTimeToday(String timeString) {
        timeString = StringKit.format("{} {}", Formatter.formatDate(new DateTime()), timeString);
        if (1 == StringKit.count((CharSequence)timeString, ':')) {
            return Formatter.parse(timeString, "yyyy-MM-dd HH:mm");
        }
        return Formatter.parse(timeString, Fields.NORM_DATETIME_FORMAT);
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(Formatter.format(date, "yyMMddHHmm"));
    }

    public static Calendar parse(CharSequence str, boolean lenient, DateParser parser) {
        Calendar calendar = Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        return parser.parse(StringKit.toString(str), new ParsePosition(0), calendar) ? calendar : null;
    }

    public static DateTime parseCST(CharSequence cstString) {
        if (null == cstString) {
            return null;
        }
        return Formatter.parse((String)cstString, Fields.JDK_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String utcString) {
        if (null == utcString) {
            return null;
        }
        int length = utcString.length();
        if (StringKit.contains((CharSequence)utcString, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return Formatter.parse(utcString, Fields.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength - 4 && length >= patternLength - 6) {
                return Formatter.parse(utcString, Fields.OUTPUT_MSEC_FORMAT);
            }
        } else {
            if (StringKit.contains((CharSequence)utcString, '+')) {
                String zoneOffset = StringKit.subAfter((CharSequence)(utcString = utcString.replace(" +", "+")), '+', true);
                if (StringKit.isBlank(zoneOffset)) {
                    throw new InstrumentException("Invalid format: [{}]", utcString);
                }
                if (!StringKit.contains((CharSequence)zoneOffset, ':')) {
                    String pre = StringKit.subBefore((CharSequence)utcString, '+', true);
                    utcString = pre + "+" + zoneOffset.substring(0, 2) + ':' + "0" + "0";
                }
                if (StringKit.contains((CharSequence)utcString, ".")) {
                    return Formatter.parse(utcString, Fields.WITH_XXX_OFFSET_FORMAT);
                }
                return Formatter.parse(utcString, Fields.WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return Formatter.parse(utcString, Fields.SIMPLE_FORMAT);
            }
            if (StringKit.contains((CharSequence)utcString, ".")) {
                return Formatter.parse(utcString, Fields.SIMPLE_MS_FORMAT);
            }
        }
        throw new InstrumentException("No format fit for date String [{}] !", utcString);
    }

    public static Calendar parseByPatterns(String text, String ... parsePatterns) {
        return Formatter.parseByPatterns(text, null, parsePatterns);
    }

    public static Calendar parseByPatterns(String text, Locale locale, String ... parsePatterns) {
        return Formatter.parseByPatterns(text, locale, true, parsePatterns);
    }

    public static Calendar parseByPatterns(String text, Locale locale, boolean lenient, String ... parsePatterns) {
        if (null == text || null == parsePatterns) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectKit.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : parsePatterns) {
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(text, pos, calendar) && pos.getIndex() == text.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new InstrumentException("Unable to parse the date: {}", text);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return Formatter.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    private static String normalize(CharSequence dateStr) {
        if (StringKit.isBlank(dateStr)) {
            return StringKit.toString(dateStr);
        }
        List<String> dateAndTime = StringKit.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringKit.toString(dateStr);
        }
        StringBuilder builder = StringKit.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringKit.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringKit.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

