/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.aoju.bus.core.lang.function.Func0;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Assert {
    private static final String TEMPLATE_VALUE_MUST_BE_BETWEEN_AND = "The value must be between {} and {}.";

    public static void isTrue(boolean expression, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (!expression) {
            Assert.isTrue(false, errorMsgSupplier.get(), new Object[0]);
        }
    }

    public static <X extends Throwable> void isTrue(boolean expression, Func0<? extends X> supplier) throws X {
        if (!expression) {
            throw (Throwable)supplier.callWithRuntimeException();
        }
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (!expression) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
    }

    public static void isTrue(boolean expression) throws IllegalArgumentException {
        Assert.isTrue(expression, "[Assertion failed] - this expression must be true", new Object[0]);
    }

    public static void isFalse(boolean expression, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (expression) {
            Assert.isFalse(true, errorMsgSupplier.get(), new Object[0]);
        }
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (expression) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
    }

    public static void isFalse(boolean expression) throws IllegalArgumentException {
        Assert.isFalse(expression, "[Assertion failed] - this expression must be false", new Object[0]);
    }

    public static void isNull(Object object, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (null != object) {
            Assert.isNull(object, errorMsgSupplier.get(), new Object[0]);
        }
    }

    public static void isNull(Object object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (null != object) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
    }

    public static void isNull(Object object) throws NullPointerException {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null", new Object[0]);
    }

    public static <T, X extends Throwable> T notNull(T object, Supplier<X> errorSupplier) throws X {
        if (null == object) {
            throw (Throwable)errorSupplier.get();
        }
        return object;
    }

    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        return Assert.notNull(object, () -> new IllegalArgumentException(StringKit.format(errorMsgTemplate, params)));
    }

    public static <T> T notNull(T object) throws IllegalArgumentException {
        return Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null", new Object[0]);
    }

    public static <T extends CharSequence> T notEmpty(T text, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (StringKit.isEmpty(text)) {
            Assert.notEmpty(text, errorMsgSupplier.get(), new Object[0]);
        }
        return text;
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (StringKit.isEmpty(text)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return text;
    }

    public static <T extends CharSequence> T notEmpty(T text) throws IllegalArgumentException {
        return Assert.notEmpty(text, "[Assertion failed] - this String argument must have length; it must not be null or empty", new Object[0]);
    }

    public static <T extends CharSequence> T notBlank(T text, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (StringKit.isBlank(text)) {
            Assert.notBlank(text, errorMsgSupplier.get(), new Object[0]);
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (StringKit.isBlank(text)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return text;
    }

    public static <T extends CharSequence> T notBlank(T text) throws IllegalArgumentException {
        return Assert.notBlank(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank", new Object[0]);
    }

    public static String notContain(String textToSearch, String substring, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (StringKit.isNotEmpty(textToSearch) && StringKit.isNotEmpty(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(errorMsgSupplier.get());
        }
        return substring;
    }

    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (StringKit.isNotEmpty(textToSearch) && StringKit.isNotEmpty(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return substring;
    }

    public static String notContain(String textToSearch, String substring) throws IllegalArgumentException {
        return Assert.notContain(textToSearch, substring, "[Assertion failed] - this String argument must not contain the substring [{}]", substring);
    }

    public static Object[] notEmpty(Object[] array, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException(errorMsgSupplier.get());
        }
        return array;
    }

    public static Object[] notEmpty(Object[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return array;
    }

    public static Object[] notEmpty(Object[] array) throws IllegalArgumentException {
        return Assert.notEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <T, X extends Throwable> T[] noNullElements(T[] array, Supplier<X> errorSupplier) throws X {
        if (ArrayKit.hasNull(array)) {
            throw (Throwable)errorSupplier.get();
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (ArrayKit.hasNull(array)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array) throws IllegalArgumentException {
        return Assert.noNullElements(array, "[Assertion failed] - this array must not contain any null elements", new Object[0]);
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (CollKit.isEmpty(collection)) {
            throw new IllegalArgumentException(errorMsgSupplier.get());
        }
        return collection;
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (CollKit.isEmpty(collection)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return collection;
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection) throws IllegalArgumentException {
        return Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element", new Object[0]);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, Supplier<String> errorMsgSupplier) throws IllegalArgumentException {
        if (CollKit.isEmpty(map)) {
            throw new IllegalArgumentException(errorMsgSupplier.get());
        }
        return map;
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        if (CollKit.isEmpty(map)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return map;
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map) throws IllegalArgumentException {
        return Assert.notEmpty(map, "[Assertion failed] - this map must not be empty; it must contain at least first entry", new Object[0]);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj) {
        return Assert.isInstanceOf(type, obj, "Object [{}] is not instanceof [{}]", obj, type);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.notNull(type, "Type to check against must not be null", new Object[0]);
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
        return obj;
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) throws IllegalArgumentException {
        Assert.isAssignable(superType, subType, "{} is not assignable to {})", subType, superType);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) throws IllegalArgumentException {
        Assert.notNull(superType, "Type to check against must not be null", new Object[0]);
        if (null == subType || !superType.isAssignableFrom(subType)) {
            throw new IllegalArgumentException(StringKit.format(errorMsgTemplate, params));
        }
    }

    public static void state(boolean expression, Supplier<String> errorMsgSupplier) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void state(boolean expression, String errorMsgTemplate, Object ... params) throws IllegalStateException {
        if (!expression) {
            throw new IllegalStateException(StringKit.format(errorMsgTemplate, params));
        }
    }

    public static void state(boolean expression) throws IllegalStateException {
        Assert.state(expression, "[Assertion failed] - this state invariant must be true", new Object[0]);
    }

    public static void hasText(String text, String message) {
        if (!StringKit.hasText(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static String badIndexMsg(int index, int size, String desc, Object ... params) {
        if (index < 0) {
            return StringKit.format("{} ({}) must not be negative", StringKit.format(desc, params), index);
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return StringKit.format("{} ({}) must be less than size ({})", StringKit.format(desc, params), index, size);
    }

    public static int checkIndex(int index, int size) throws IllegalArgumentException, IndexOutOfBoundsException {
        return Assert.checkIndex(index, size, "[Assertion failed]", new Object[0]);
    }

    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Assert.badIndexMsg(index, size, errorMsgTemplate, params));
        }
        return index;
    }

    public static <X extends Throwable> int checkBetween(int value, int min, int max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static int checkBetween(int value, int min, int max, String template, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new IllegalArgumentException(StringKit.format(template, params)));
    }

    public static int checkBetween(int value, int min, int max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{min, max});
    }

    public static <X extends Throwable> long checkBetween(long value, long min, long max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static long checkBetween(long value, long min, long max, String template, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new IllegalArgumentException(StringKit.format(template, params)));
    }

    public static long checkBetween(long value, long min, long max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, new Object[]{min, max});
    }

    public static <X extends Throwable> double checkBetween(double value, double min, double max, Supplier<? extends X> errorSupplier) throws X {
        if (value < min || value > max) {
            throw (Throwable)errorSupplier.get();
        }
        return value;
    }

    public static double checkBetween(double value, double min, double max, String template, Object ... params) {
        return Assert.checkBetween(value, min, max, () -> new IllegalArgumentException(StringKit.format(template, params)));
    }

    public static double checkBetween(double value, double min, double max) {
        return Assert.checkBetween(value, min, max, TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, min, max);
    }

    public static Number checkBetween(Number value, Number min, Number max) {
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double valueDouble = value.doubleValue();
        double minDouble = min.doubleValue();
        double maxDouble = max.doubleValue();
        if (valueDouble < minDouble || valueDouble > maxDouble) {
            throw new IllegalArgumentException(StringKit.format(TEMPLATE_VALUE_MUST_BE_BETWEEN_AND, min, max));
        }
        return value;
    }
}

