/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Similarity {
    public static double similar(String texta, String textb) {
        String newStrB;
        String newStrA;
        if (texta.length() < textb.length()) {
            newStrA = Similarity.removeSign(textb);
            newStrB = Similarity.removeSign(texta);
        } else {
            newStrA = Similarity.removeSign(texta);
            newStrB = Similarity.removeSign(textb);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        if (0 == temp) {
            return 1.0;
        }
        int commonLength = Similarity.longestCommonSubstringLength(newStrA, newStrB);
        return MathKit.div((float)commonLength, (float)temp);
    }

    public static String similar(String texta, String textb, int scale) {
        return MathKit.formatPercent(Similarity.similar(texta, textb), scale);
    }

    public static String longestCommonSubstring(String texta, String textb) {
        int[][] matrix = Similarity.generateMatrix(texta, textb);
        int m = texta.length();
        int n = textb.length();
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[m][n] == matrix[m][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = texta.charAt(m - 1);
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }

    private static String removeSign(String text) {
        int length = text.length();
        StringBuilder sb = StringKit.builder(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (!Similarity.isValidChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isValidChar(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u9fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static int longestCommonSubstringLength(String texta, String textb) {
        int m = texta.length();
        int n = textb.length();
        return Similarity.generateMatrix(texta, textb)[m][n];
    }

    private static int[][] generateMatrix(String texta, String textb) {
        int m = texta.length();
        int n = textb.length();
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = texta.charAt(i - 1) == textb.charAt(j - 1) ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        return matrix;
    }
}

