/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.Objects;
import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.text.Matchers;
import org.aoju.bus.core.toolkit.ArrayKit;

public class TextBuilder
implements CharSequence,
Appendable,
Builder<String> {
    private static final long serialVersionUID = 1L;
    private static final int CAPACITY = 16;
    public char[] buffer;
    public int indexes;
    private String newLine;
    private String nullText;

    public TextBuilder() {
        this(16);
    }

    public TextBuilder(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 16;
        }
        this.buffer = new char[initialCapacity];
    }

    public TextBuilder(String text) {
        if (null == text) {
            this.buffer = new char[16];
        } else {
            this.buffer = new char[text.length() + 16];
            this.append(text);
        }
    }

    public TextBuilder(CharSequence ... texts) {
        this(ArrayKit.isEmpty(texts) ? 16 : TextBuilder.totalLength(texts) + 16);
        for (int i = 0; i < texts.length; ++i) {
            this.append(texts[i]);
        }
    }

    public static TextBuilder create() {
        return new TextBuilder();
    }

    public static TextBuilder create(int initialCapacity) {
        return new TextBuilder(initialCapacity);
    }

    public static TextBuilder create(CharSequence ... texts) {
        return new TextBuilder(texts);
    }

    private static int totalLength(CharSequence ... texts) {
        int totalLength = 0;
        for (CharSequence text : texts) {
            totalLength += null == text ? 4 : text.length();
        }
        return totalLength;
    }

    @Override
    public int length() {
        return this.indexes;
    }

    @Override
    public char charAt(int index) {
        if (index < 0) {
            index = this.indexes + index;
        }
        if (index < 0 || index > this.indexes) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.buffer[index];
    }

    public String getNewLineText() {
        return this.newLine;
    }

    public TextBuilder setNewLineText(String newLine) {
        this.newLine = newLine;
        return this;
    }

    public String getNullText() {
        return this.nullText;
    }

    public TextBuilder setNullText(String nullText) {
        if (null != nullText && nullText.isEmpty()) {
            nullText = null;
        }
        this.nullText = nullText;
        return this;
    }

    public TextBuilder setLength(int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (length < this.indexes) {
            this.indexes = length;
        } else if (length > this.indexes) {
            this.ensureCapacity(length);
            int oldEnd = this.indexes;
            int newEnd = length;
            this.indexes = length;
            for (int i = oldEnd; i < newEnd; ++i) {
                this.buffer[i] = '\u0000';
            }
        }
        return this;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public TextBuilder ensureCapacity(int capacity) {
        if (capacity > this.buffer.length) {
            char[] old = this.buffer;
            this.buffer = new char[capacity * 2];
            System.arraycopy(old, 0, this.buffer, 0, this.indexes);
        }
        return this;
    }

    public int indexes() {
        return this.indexes;
    }

    @Override
    public boolean isEmpty() {
        return this.indexes == 0;
    }

    public TextBuilder clear() {
        return this.reset();
    }

    public TextBuilder reset() {
        this.indexes = 0;
        return this;
    }

    public TextBuilder setCharAt(int index, char ch) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.buffer[index] = ch;
        return this;
    }

    public TextBuilder deleteCharAt(int index) {
        if (index < 0 || index >= this.indexes) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.deleteImpl(index, index + 1, 1);
        return this;
    }

    public char[] getChars(char[] destination) {
        int len = this.length();
        if (null == destination || destination.length < len) {
            destination = new char[len];
        }
        System.arraycopy(this.buffer, 0, destination, 0, len);
        return destination;
    }

    public void getChars(int startIndex, int endIndex, char[] destination, int destinationIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0 || endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.buffer, startIndex, destination, destinationIndex, endIndex - startIndex);
    }

    public int readFrom(Readable readable) throws IOException {
        int oldSize = this.indexes;
        if (readable instanceof Reader) {
            int read;
            Reader r = (Reader)readable;
            this.ensureCapacity(this.indexes + 1);
            while ((read = r.read(this.buffer, this.indexes, this.buffer.length - this.indexes)) != -1) {
                this.indexes += read;
                this.ensureCapacity(this.indexes + 1);
            }
        } else if (readable instanceof CharBuffer) {
            CharBuffer cb = (CharBuffer)readable;
            int remaining = cb.remaining();
            this.ensureCapacity(this.indexes + remaining);
            cb.get(this.buffer, this.indexes, remaining);
            this.indexes += remaining;
        } else {
            while (true) {
                this.ensureCapacity(this.indexes + 1);
                CharBuffer buf = CharBuffer.wrap(this.buffer, this.indexes, this.buffer.length - this.indexes);
                int read = readable.read(buf);
                if (read == -1) break;
                this.indexes += read;
            }
        }
        return this.indexes - oldSize;
    }

    public TextBuilder appendNewLine() {
        if (null == this.newLine) {
            this.append(System.getProperty("line.separator"));
            return this;
        }
        return this.append(this.newLine);
    }

    public TextBuilder appendNull() {
        if (null == this.nullText) {
            return this;
        }
        return this.append(this.nullText);
    }

    public TextBuilder append(Object obj) {
        if (null == obj) {
            return this.appendNull();
        }
        if (obj instanceof CharSequence) {
            return this.append((CharSequence)obj);
        }
        return this.append(obj.toString());
    }

    @Override
    public TextBuilder append(CharSequence seq) {
        if (null == seq) {
            return this.appendNull();
        }
        if (seq instanceof TextBuilder) {
            return this.append((TextBuilder)seq);
        }
        if (seq instanceof StringBuilder) {
            return this.append((StringBuilder)seq);
        }
        if (seq instanceof StringBuffer) {
            return this.append((StringBuffer)seq);
        }
        if (seq instanceof CharBuffer) {
            return this.append((CharBuffer)seq);
        }
        return this.append(seq.toString());
    }

    @Override
    public TextBuilder append(CharSequence seq, int startIndex, int length) {
        if (null == seq) {
            return this.appendNull();
        }
        return this.append(seq.toString(), startIndex, length);
    }

    public TextBuilder append(String text) {
        if (null == text) {
            return this.appendNull();
        }
        int strLen = text.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            text.getChars(0, strLen, this.buffer, len);
            this.indexes += strLen;
        }
        return this;
    }

    public TextBuilder append(String text, int startIndex, int length) {
        if (null == text) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > text.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > text.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int len = this.length();
            this.ensureCapacity(len + length);
            text.getChars(startIndex, startIndex + length, this.buffer, len);
            this.indexes += length;
        }
        return this;
    }

    public TextBuilder append(String format, Object ... objs) {
        return this.append(String.format(format, objs));
    }

    public TextBuilder append(CharBuffer buf) {
        if (null == buf) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int length = buf.remaining();
            int len = this.length();
            this.ensureCapacity(len + length);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position(), this.buffer, len, length);
            this.indexes += length;
        } else {
            this.append(buf.toString());
        }
        return this;
    }

    public TextBuilder append(CharBuffer buf, int startIndex, int length) {
        if (null == buf) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int totalLength = buf.remaining();
            if (startIndex < 0 || startIndex > totalLength) {
                throw new StringIndexOutOfBoundsException("startIndex must be valid");
            }
            if (length < 0 || startIndex + length > totalLength) {
                throw new StringIndexOutOfBoundsException("length must be valid");
            }
            int len = this.length();
            this.ensureCapacity(len + length);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position() + startIndex, this.buffer, len, length);
            this.indexes += length;
        } else {
            this.append(buf.toString(), startIndex, length);
        }
        return this;
    }

    public TextBuilder append(StringBuffer text) {
        if (null == text) {
            return this.appendNull();
        }
        int strLen = text.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            text.getChars(0, strLen, this.buffer, len);
            this.indexes += strLen;
        }
        return this;
    }

    public TextBuilder append(StringBuffer text, int startIndex, int length) {
        if (null == text) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > text.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > text.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int len = this.length();
            this.ensureCapacity(len + length);
            text.getChars(startIndex, startIndex + length, this.buffer, len);
            this.indexes += length;
        }
        return this;
    }

    public TextBuilder append(StringBuilder text) {
        if (null == text) {
            return this.appendNull();
        }
        int strLen = text.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            text.getChars(0, strLen, this.buffer, len);
            this.indexes += strLen;
        }
        return this;
    }

    public TextBuilder append(StringBuilder text, int startIndex, int length) {
        if (null == text) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > text.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > text.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int len = this.length();
            this.ensureCapacity(len + length);
            text.getChars(startIndex, startIndex + length, this.buffer, len);
            this.indexes += length;
        }
        return this;
    }

    public TextBuilder append(TextBuilder text) {
        if (null == text) {
            return this.appendNull();
        }
        int strLen = text.length();
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            System.arraycopy(text.buffer, 0, this.buffer, len, strLen);
            this.indexes += strLen;
        }
        return this;
    }

    public TextBuilder append(TextBuilder text, int startIndex, int length) {
        if (null == text) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > text.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > text.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int len = this.length();
            this.ensureCapacity(len + length);
            text.getChars(startIndex, startIndex + length, this.buffer, len);
            this.indexes += length;
        }
        return this;
    }

    public TextBuilder append(char[] chars) {
        if (null == chars) {
            return this.appendNull();
        }
        int strLen = chars.length;
        if (strLen > 0) {
            int len = this.length();
            this.ensureCapacity(len + strLen);
            System.arraycopy(chars, 0, this.buffer, len, strLen);
            this.indexes += strLen;
        }
        return this;
    }

    public TextBuilder append(char[] chars, int startIndex, int length) {
        if (null == chars) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + length);
        }
        if (length < 0 || startIndex + length > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length);
        }
        if (length > 0) {
            int len = this.length();
            this.ensureCapacity(len + length);
            System.arraycopy(chars, startIndex, this.buffer, len, length);
            this.indexes += length;
        }
        return this;
    }

    public TextBuilder append(boolean value) {
        if (value) {
            this.ensureCapacity(this.indexes + 4);
            this.buffer[this.indexes++] = 116;
            this.buffer[this.indexes++] = 114;
            this.buffer[this.indexes++] = 117;
            this.buffer[this.indexes++] = 101;
        } else {
            this.ensureCapacity(this.indexes + 5);
            this.buffer[this.indexes++] = 102;
            this.buffer[this.indexes++] = 97;
            this.buffer[this.indexes++] = 108;
            this.buffer[this.indexes++] = 115;
            this.buffer[this.indexes++] = 101;
        }
        return this;
    }

    @Override
    public TextBuilder append(char ch) {
        int len = this.length();
        this.ensureCapacity(len + 1);
        this.buffer[this.indexes++] = ch;
        return this;
    }

    public TextBuilder append(int value) {
        return this.append(String.valueOf(value));
    }

    public TextBuilder append(long value) {
        return this.append(String.valueOf(value));
    }

    public TextBuilder append(float value) {
        return this.append(String.valueOf(value));
    }

    public TextBuilder append(double value) {
        return this.append(String.valueOf(value));
    }

    public TextBuilder appendln(Object obj) {
        return this.append(obj).appendNewLine();
    }

    public TextBuilder appendln(String text) {
        return this.append(text).appendNewLine();
    }

    public TextBuilder appendln(String text, int startIndex, int length) {
        return this.append(text, startIndex, length).appendNewLine();
    }

    public TextBuilder appendln(String format, Object ... objs) {
        return this.append(format, objs).appendNewLine();
    }

    public TextBuilder appendln(StringBuffer text) {
        return this.append(text).appendNewLine();
    }

    public TextBuilder appendln(StringBuilder text) {
        return this.append(text).appendNewLine();
    }

    public TextBuilder appendln(StringBuilder text, int startIndex, int length) {
        return this.append(text, startIndex, length).appendNewLine();
    }

    public TextBuilder appendln(StringBuffer text, int startIndex, int length) {
        return this.append(text, startIndex, length).appendNewLine();
    }

    public TextBuilder appendln(TextBuilder text) {
        return this.append(text).appendNewLine();
    }

    public TextBuilder appendln(TextBuilder text, int startIndex, int length) {
        return this.append(text, startIndex, length).appendNewLine();
    }

    public TextBuilder appendln(char[] chars) {
        return this.append(chars).appendNewLine();
    }

    public TextBuilder appendln(char[] chars, int startIndex, int length) {
        return this.append(chars, startIndex, length).appendNewLine();
    }

    public TextBuilder appendln(boolean value) {
        return this.append(value).appendNewLine();
    }

    public TextBuilder appendln(char ch) {
        return this.append(ch).appendNewLine();
    }

    public TextBuilder appendln(int value) {
        return this.append(value).appendNewLine();
    }

    public TextBuilder appendln(long value) {
        return this.append(value).appendNewLine();
    }

    public TextBuilder appendln(float value) {
        return this.append(value).appendNewLine();
    }

    public TextBuilder appendln(double value) {
        return this.append(value).appendNewLine();
    }

    public <T> TextBuilder appendAll(T ... array) {
        if (null != array && array.length > 0) {
            for (T element : array) {
                this.append(element);
            }
        }
        return this;
    }

    public TextBuilder appendAll(Iterable<?> iterable) {
        if (null != iterable) {
            for (Object o : iterable) {
                this.append(o);
            }
        }
        return this;
    }

    public TextBuilder appendAll(Iterator<?> it) {
        if (null != it) {
            while (it.hasNext()) {
                this.append(it.next());
            }
        }
        return this;
    }

    public TextBuilder appendWithSeparators(Object[] array, String separator) {
        if (null != array && array.length > 0) {
            String sep = Objects.toString(separator, "");
            this.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                this.append(sep);
                this.append(array[i]);
            }
        }
        return this;
    }

    public TextBuilder appendWithSeparators(Iterable<?> iterable, String separator) {
        if (null != iterable) {
            String sep = Objects.toString(separator, "");
            Iterator<?> it = iterable.iterator();
            while (it.hasNext()) {
                this.append(it.next());
                if (!it.hasNext()) continue;
                this.append(sep);
            }
        }
        return this;
    }

    public TextBuilder appendWithSeparators(Iterator<?> it, String separator) {
        if (null != it) {
            String sep = Objects.toString(separator, "");
            while (it.hasNext()) {
                this.append(it.next());
                if (!it.hasNext()) continue;
                this.append(sep);
            }
        }
        return this;
    }

    public TextBuilder appendFixedWidthPadLeft(Object obj, int width, char padChar) {
        if (width > 0) {
            int strLen;
            String text;
            this.ensureCapacity(this.indexes + width);
            String string = text = null == obj ? this.getNullText() : obj.toString();
            if (null == text) {
                text = "";
            }
            if ((strLen = text.length()) >= width) {
                text.getChars(strLen - width, strLen, this.buffer, this.indexes);
            } else {
                int padLen = width - strLen;
                for (int i = 0; i < padLen; ++i) {
                    this.buffer[this.indexes + i] = padChar;
                }
                text.getChars(0, strLen, this.buffer, this.indexes + padLen);
            }
            this.indexes += width;
        }
        return this;
    }

    public TextBuilder appendFixedWidthPadLeft(int value, int width, char padChar) {
        return this.appendFixedWidthPadLeft(String.valueOf(value), width, padChar);
    }

    public TextBuilder appendFixedWidthPadRight(Object obj, int width, char padChar) {
        if (width > 0) {
            int strLen;
            String text;
            this.ensureCapacity(this.indexes + width);
            String string = text = null == obj ? this.getNullText() : obj.toString();
            if (null == text) {
                text = "";
            }
            if ((strLen = text.length()) >= width) {
                text.getChars(0, width, this.buffer, this.indexes);
            } else {
                int padLen = width - strLen;
                text.getChars(0, strLen, this.buffer, this.indexes);
                for (int i = 0; i < padLen; ++i) {
                    this.buffer[this.indexes + strLen + i] = padChar;
                }
            }
            this.indexes += width;
        }
        return this;
    }

    public TextBuilder appendFixedWidthPadRight(int value, int width, char padChar) {
        return this.appendFixedWidthPadRight(String.valueOf(value), width, padChar);
    }

    public TextBuilder insert(int index, Object obj) {
        if (null == obj) {
            return this.insert(index, this.nullText);
        }
        return this.insert(index, obj.toString());
    }

    public TextBuilder insert(int index, String text) {
        int strLen;
        this.validateIndex(index);
        if (null == text) {
            text = this.nullText;
        }
        if (null != text && (strLen = text.length()) > 0) {
            int newSize = this.indexes + strLen;
            this.ensureCapacity(newSize);
            System.arraycopy(this.buffer, index, this.buffer, index + strLen, this.indexes - index);
            this.indexes = newSize;
            text.getChars(0, strLen, this.buffer, index);
        }
        return this;
    }

    public TextBuilder insert(int index, char[] chars) {
        this.validateIndex(index);
        if (null == chars) {
            return this.insert(index, this.nullText);
        }
        int len = chars.length;
        if (len > 0) {
            this.ensureCapacity(this.indexes + len);
            System.arraycopy(this.buffer, index, this.buffer, index + len, this.indexes - index);
            System.arraycopy(chars, 0, this.buffer, index, len);
            this.indexes += len;
        }
        return this;
    }

    public TextBuilder insert(int index, char[] chars, int offset, int length) {
        this.validateIndex(index);
        if (null == chars) {
            return this.insert(index, this.nullText);
        }
        if (offset < 0 || offset > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + offset);
        }
        if (length < 0 || offset + length > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length);
        }
        if (length > 0) {
            this.ensureCapacity(this.indexes + length);
            System.arraycopy(this.buffer, index, this.buffer, index + length, this.indexes - index);
            System.arraycopy(chars, offset, this.buffer, index, length);
            this.indexes += length;
        }
        return this;
    }

    public TextBuilder insert(int index, boolean value) {
        this.validateIndex(index);
        if (value) {
            this.ensureCapacity(this.indexes + 4);
            System.arraycopy(this.buffer, index, this.buffer, index + 4, this.indexes - index);
            this.buffer[index++] = 116;
            this.buffer[index++] = 114;
            this.buffer[index++] = 117;
            this.buffer[index] = 101;
            this.indexes += 4;
        } else {
            this.ensureCapacity(this.indexes + 5);
            System.arraycopy(this.buffer, index, this.buffer, index + 5, this.indexes - index);
            this.buffer[index++] = 102;
            this.buffer[index++] = 97;
            this.buffer[index++] = 108;
            this.buffer[index++] = 115;
            this.buffer[index] = 101;
            this.indexes += 5;
        }
        return this;
    }

    public TextBuilder insert(int index, char value) {
        this.validateIndex(index);
        this.ensureCapacity(this.indexes + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.indexes - index);
        this.buffer[index] = value;
        ++this.indexes;
        return this;
    }

    public TextBuilder insert(int index, int value) {
        return this.insert(index, String.valueOf(value));
    }

    public TextBuilder insert(int index, long value) {
        return this.insert(index, String.valueOf(value));
    }

    public TextBuilder insert(int index, float value) {
        return this.insert(index, String.valueOf(value));
    }

    public TextBuilder insert(int index, double value) {
        return this.insert(index, String.valueOf(value));
    }

    private void deleteImpl(int startIndex, int endIndex, int len) {
        System.arraycopy(this.buffer, endIndex, this.buffer, startIndex, this.indexes - endIndex);
        this.indexes -= len;
    }

    public TextBuilder delete(int startIndex, int endIndex) {
        int len = (endIndex = this.validateRange(startIndex, endIndex)) - startIndex;
        if (len > 0) {
            this.deleteImpl(startIndex, endIndex, len);
        }
        return this;
    }

    public TextBuilder deleteAll(char ch) {
        for (int i = 0; i < this.indexes; ++i) {
            if (this.buffer[i] != ch) continue;
            int start = i;
            while (++i < this.indexes && this.buffer[i] == ch) {
            }
            int len = i - start;
            this.deleteImpl(start, i, len);
            i -= len;
        }
        return this;
    }

    public TextBuilder deleteFirst(char ch) {
        for (int i = 0; i < this.indexes; ++i) {
            if (this.buffer[i] != ch) continue;
            this.deleteImpl(i, i + 1, 1);
            break;
        }
        return this;
    }

    public TextBuilder deleteAll(String text) {
        int len;
        int n = len = null == text ? 0 : text.length();
        if (len > 0) {
            int index = this.indexOf(text, 0);
            while (index >= 0) {
                this.deleteImpl(index, index + len, len);
                index = this.indexOf(text, index);
            }
        }
        return this;
    }

    public TextBuilder deleteFirst(String text) {
        int index;
        int len;
        int n = len = null == text ? 0 : text.length();
        if (len > 0 && (index = this.indexOf(text, 0)) >= 0) {
            this.deleteImpl(index, index + len, len);
        }
        return this;
    }

    public TextBuilder deleteAll(Matchers matcher) {
        return this.replace(matcher, null, 0, this.indexes, -1);
    }

    public TextBuilder deleteFirst(Matchers matcher) {
        return this.replace(matcher, null, 0, this.indexes, 1);
    }

    private void replaceImpl(int startIndex, int endIndex, int removeLen, String insertStr, int insertLen) {
        int newSize = this.indexes - removeLen + insertLen;
        if (insertLen != removeLen) {
            this.ensureCapacity(newSize);
            System.arraycopy(this.buffer, endIndex, this.buffer, startIndex + insertLen, this.indexes - endIndex);
            this.indexes = newSize;
        }
        if (insertLen > 0) {
            insertStr.getChars(0, insertLen, this.buffer, startIndex);
        }
    }

    public TextBuilder replace(int startIndex, int endIndex, String replaceStr) {
        endIndex = this.validateRange(startIndex, endIndex);
        int insertLen = null == replaceStr ? 0 : replaceStr.length();
        this.replaceImpl(startIndex, endIndex, endIndex - startIndex, replaceStr, insertLen);
        return this;
    }

    public TextBuilder replaceAll(char search, char replace) {
        if (search != replace) {
            for (int i = 0; i < this.indexes; ++i) {
                if (this.buffer[i] != search) continue;
                this.buffer[i] = replace;
            }
        }
        return this;
    }

    public TextBuilder replaceFirst(char search, char replace) {
        if (search != replace) {
            for (int i = 0; i < this.indexes; ++i) {
                if (this.buffer[i] != search) continue;
                this.buffer[i] = replace;
                break;
            }
        }
        return this;
    }

    public TextBuilder replaceAll(String searchStr, String replaceStr) {
        int searchLen;
        int n = searchLen = null == searchStr ? 0 : searchStr.length();
        if (searchLen > 0) {
            int replaceLen = null == replaceStr ? 0 : replaceStr.length();
            int index = this.indexOf(searchStr, 0);
            while (index >= 0) {
                this.replaceImpl(index, index + searchLen, searchLen, replaceStr, replaceLen);
                index = this.indexOf(searchStr, index + replaceLen);
            }
        }
        return this;
    }

    public TextBuilder replaceFirst(String searchStr, String replaceStr) {
        int index;
        int searchLen;
        int n = searchLen = null == searchStr ? 0 : searchStr.length();
        if (searchLen > 0 && (index = this.indexOf(searchStr, 0)) >= 0) {
            int replaceLen = null == replaceStr ? 0 : replaceStr.length();
            this.replaceImpl(index, index + searchLen, searchLen, replaceStr, replaceLen);
        }
        return this;
    }

    public TextBuilder replaceAll(Matchers matcher, String replaceStr) {
        return this.replace(matcher, replaceStr, 0, this.indexes, -1);
    }

    public TextBuilder replaceFirst(Matchers matcher, String replaceStr) {
        return this.replace(matcher, replaceStr, 0, this.indexes, 1);
    }

    public TextBuilder replace(Matchers matcher, String replaceStr, int startIndex, int endIndex, int replaceCount) {
        endIndex = this.validateRange(startIndex, endIndex);
        return this.replaceImpl(matcher, replaceStr, startIndex, endIndex, replaceCount);
    }

    private TextBuilder replaceImpl(Matchers matcher, String replaceStr, int from, int to, int replaceCount) {
        if (null == matcher || this.indexes == 0) {
            return this;
        }
        int replaceLen = null == replaceStr ? 0 : replaceStr.length();
        char[] buf = this.buffer;
        for (int i = from; i < to && replaceCount != 0; ++i) {
            int removeLen = matcher.isMatch(buf, i, from, to);
            if (removeLen <= 0) continue;
            this.replaceImpl(i, i + removeLen, removeLen, replaceStr, replaceLen);
            to = to - removeLen + replaceLen;
            i = i + replaceLen - 1;
            if (replaceCount <= 0) continue;
            --replaceCount;
        }
        return this;
    }

    public TextBuilder reverse() {
        if (this.indexes == 0) {
            return this;
        }
        int half = this.indexes / 2;
        char[] buf = this.buffer;
        int leftIdx = 0;
        int rightIdx = this.indexes - 1;
        while (leftIdx < half) {
            char swap = buf[leftIdx];
            buf[leftIdx] = buf[rightIdx];
            buf[rightIdx] = swap;
            ++leftIdx;
            --rightIdx;
        }
        return this;
    }

    public TextBuilder trim() {
        int pos;
        if (this.indexes == 0) {
            return this;
        }
        int len = this.indexes;
        char[] buf = this.buffer;
        for (pos = 0; pos < len && buf[pos] <= ' '; ++pos) {
        }
        while (pos < len && buf[len - 1] <= ' ') {
            --len;
        }
        if (len < this.indexes) {
            this.delete(len, this.indexes);
        }
        if (pos > 0) {
            this.delete(0, pos);
        }
        return this;
    }

    public boolean startsWith(String text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        if (len == 0) {
            return true;
        }
        if (len > this.indexes) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[i] == text.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String text) {
        if (null == text) {
            return false;
        }
        int len = text.length();
        if (len == 0) {
            return true;
        }
        if (len > this.indexes) {
            return false;
        }
        int pos = this.indexes - len;
        int i = 0;
        while (i < len) {
            if (this.buffer[pos] != text.charAt(i)) {
                return false;
            }
            ++i;
            ++pos;
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subString(start, end);
    }

    public String subString(int start) {
        return this.subString(start, this.indexes);
    }

    public String subString(int start, int end) {
        return new String(this.buffer, start, end - start);
    }

    public String leftString(int length) {
        if (length <= 0) {
            return "";
        }
        if (length >= this.indexes) {
            return new String(this.buffer, 0, this.indexes);
        }
        return new String(this.buffer, 0, length);
    }

    public String rightString(int length) {
        if (length <= 0) {
            return "";
        }
        if (length >= this.indexes) {
            return new String(this.buffer, 0, this.indexes);
        }
        return new String(this.buffer, this.indexes - length, length);
    }

    public String midString(int index, int length) {
        if (index < 0) {
            index = 0;
        }
        if (length <= 0 || index >= this.indexes) {
            return "";
        }
        if (this.indexes <= index + length) {
            return new String(this.buffer, index, this.indexes - index);
        }
        return new String(this.buffer, index, length);
    }

    public boolean contains(char ch) {
        char[] thisBuf = this.buffer;
        for (int i = 0; i < this.indexes; ++i) {
            if (thisBuf[i] != ch) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String text) {
        return this.indexOf(text, 0) >= 0;
    }

    public boolean contains(Matchers matcher) {
        return this.indexOf(matcher, 0) >= 0;
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(char ch, int startIndex) {
        int n = startIndex = startIndex < 0 ? 0 : startIndex;
        if (startIndex >= this.indexes) {
            return -1;
        }
        char[] thisBuf = this.buffer;
        for (int i = startIndex; i < this.indexes; ++i) {
            if (thisBuf[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String text) {
        return this.indexOf(text, 0);
    }

    public int indexOf(String text, int startIndex) {
        int n = startIndex = startIndex < 0 ? 0 : startIndex;
        if (null == text || startIndex >= this.indexes) {
            return -1;
        }
        int strLen = text.length();
        if (strLen == 1) {
            return this.indexOf(text.charAt(0), startIndex);
        }
        if (strLen == 0) {
            return startIndex;
        }
        if (strLen > this.indexes) {
            return -1;
        }
        char[] thisBuf = this.buffer;
        int len = this.indexes - strLen + 1;
        block0: for (int i = startIndex; i < len; ++i) {
            for (int j = 0; j < strLen; ++j) {
                if (text.charAt(j) != thisBuf[i + j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public int indexOf(Matchers matcher) {
        return this.indexOf(matcher, 0);
    }

    public int indexOf(Matchers matcher, int startIndex) {
        int n = startIndex = startIndex < 0 ? 0 : startIndex;
        if (null == matcher || startIndex >= this.indexes) {
            return -1;
        }
        int len = this.indexes;
        char[] buf = this.buffer;
        for (int i = startIndex; i < len; ++i) {
            if (matcher.isMatch(buf, i, startIndex, len) <= 0) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.indexes - 1);
    }

    public int lastIndexOf(char ch, int startIndex) {
        int n = startIndex = startIndex >= this.indexes ? this.indexes - 1 : startIndex;
        if (startIndex < 0) {
            return -1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (this.buffer[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(String text) {
        return this.lastIndexOf(text, this.indexes - 1);
    }

    public int lastIndexOf(String text, int startIndex) {
        int n = startIndex = startIndex >= this.indexes ? this.indexes - 1 : startIndex;
        if (null == text || startIndex < 0) {
            return -1;
        }
        int strLen = text.length();
        if (strLen > 0 && strLen <= this.indexes) {
            if (strLen == 1) {
                return this.lastIndexOf(text.charAt(0), startIndex);
            }
            block0: for (int i = startIndex - strLen + 1; i >= 0; --i) {
                for (int j = 0; j < strLen; ++j) {
                    if (text.charAt(j) != this.buffer[i + j]) continue block0;
                }
                return i;
            }
        } else if (strLen == 0) {
            return startIndex;
        }
        return -1;
    }

    public int lastIndexOf(Matchers matcher) {
        return this.lastIndexOf(matcher, this.indexes);
    }

    public int lastIndexOf(Matchers matcher, int startIndex) {
        int n = startIndex = startIndex >= this.indexes ? this.indexes - 1 : startIndex;
        if (null == matcher || startIndex < 0) {
            return -1;
        }
        char[] buf = this.buffer;
        int endIndex = startIndex + 1;
        for (int i = startIndex; i >= 0; --i) {
            if (matcher.isMatch(buf, i, 0, endIndex) <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean equalsIgnoreCase(TextBuilder other) {
        if (this == other) {
            return true;
        }
        if (this.indexes != other.indexes) {
            return false;
        }
        char[] thisBuf = this.buffer;
        char[] otherBuf = other.buffer;
        for (int i = this.indexes - 1; i >= 0; --i) {
            char c1 = thisBuf[i];
            char c2 = otherBuf[i];
            if (c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(TextBuilder other) {
        if (this == other) {
            return true;
        }
        if (null == other) {
            return false;
        }
        if (this.indexes != other.indexes) {
            return false;
        }
        char[] thisBuf = this.buffer;
        char[] otherBuf = other.buffer;
        for (int i = this.indexes - 1; i >= 0; --i) {
            if (thisBuf[i] == otherBuf[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String build() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof TextBuilder && this.equals((TextBuilder)obj);
    }

    public int hashCode() {
        char[] buf = this.buffer;
        int hash = 0;
        for (int i = this.indexes - 1; i >= 0; --i) {
            hash = 31 * hash + buf[i];
        }
        return hash;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.indexes);
    }

    public String toString(boolean isReset) {
        if (this.indexes > 0) {
            String s = new String(this.buffer, 0, this.indexes);
            if (isReset) {
                this.reset();
            }
            return s;
        }
        return "";
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.indexes).append(this.buffer, 0, this.indexes);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.indexes).append(this.buffer, 0, this.indexes);
    }

    protected int validateRange(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex > this.indexes) {
            endIndex = this.indexes;
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return endIndex;
    }

    protected void validateIndex(int index) {
        if (index < 0 || index > this.indexes) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }
}

