/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.StringKit;

public class TextUnicode {
    public static String toUnicode(char c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(int c) {
        return HexKit.toUnicodeHex(c);
    }

    public static String toUnicode(String str) {
        return TextUnicode.toUnicode(str, true);
    }

    public static String toUnicode(String str, boolean isSkipAscii) {
        if (StringKit.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        TextBuilder unicode = TextBuilder.create(str.length() * 6);
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (isSkipAscii && CharsKit.isAsciiPrintable(c)) {
                unicode.append(c);
                continue;
            }
            unicode.append(HexKit.toUnicodeHex(c));
        }
        return unicode.toString();
    }

    public static String toString(String unicode) {
        int i;
        if (StringKit.isBlank(unicode)) {
            return unicode;
        }
        int len = unicode.length();
        TextBuilder sb = TextBuilder.create(len);
        int pos = 0;
        while ((i = StringKit.indexOfIgnoreCase(unicode, "\\u", pos)) != -1) {
            sb.append(unicode, pos, i);
            pos = i;
            if (i + 5 >= len) break;
            try {
                char c = (char)Integer.parseInt(unicode.substring(i + 2, i + 6), 16);
                sb.append(c);
                pos = i + 6;
            }
            catch (NumberFormatException e) {
                sb.append(unicode, pos, i + 2);
                pos = i + 2;
            }
        }
        if (pos < len) {
            sb.append(unicode, pos, len);
        }
        return sb.toString();
    }
}

