/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.finder;

import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.text.finder.TextFinder;
import org.aoju.bus.core.toolkit.StringKit;

public class StringFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final CharSequence word;
    private final boolean caseInsensitive;

    public StringFinder(CharSequence word, boolean caseInsensitive) {
        Assert.notEmpty(word);
        this.word = word;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        return StringKit.indexOf(this.text, this.word, from, this.caseInsensitive);
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + this.word.length();
    }
}

