/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.tree.NodeConfig;
import org.aoju.bus.core.lang.tree.Tree;
import org.aoju.bus.core.lang.tree.TreeBuilder;
import org.aoju.bus.core.lang.tree.TreeNode;
import org.aoju.bus.core.lang.tree.parser.DefaultNodeParser;
import org.aoju.bus.core.lang.tree.parser.NodeParser;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class TreeKit {
    public static Tree<Integer> buildSingle(List<TreeNode<Integer>> list) {
        return TreeKit.buildSingle(list, Integer.valueOf(0));
    }

    public static List<Tree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeKit.build(list, Integer.valueOf(0));
    }

    public static <E> Tree<E> buildSingle(List<TreeNode<E>> list, E parentId) {
        return TreeKit.buildSingle(list, parentId, NodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <E> List<Tree<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeKit.build(list, parentId, NodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> Tree<E> buildSingle(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeKit.buildSingle(list, parentId, NodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeKit.build(list, parentId, NodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E rootId, NodeConfig nodeConfig, NodeParser<T, E> nodeParser) {
        return TreeKit.buildSingle(list, rootId, nodeConfig, nodeParser).getChildren();
    }

    public static <T, E> Tree<E> buildSingle(List<T> list, E rootId, NodeConfig nodeConfig, NodeParser<T, E> nodeParser) {
        return TreeBuilder.of(rootId, nodeConfig).append(list, nodeParser).build();
    }

    public static <E> List<Tree<E>> build(Map<E, Tree<E>> map, E rootId) {
        return TreeKit.buildSingle(map, rootId).getChildren();
    }

    public static <E> Tree<E> buildSingle(Map<E, Tree<E>> map, E rootId) {
        Tree<E> tree = IterKit.getFirstNoneNull(map.values());
        if (null != tree) {
            NodeConfig config = tree.getConfig();
            return TreeBuilder.of(rootId, config).append(map).build();
        }
        return TreeKit.createEmptyNode(rootId);
    }

    public static <T> Tree<T> getNode(Tree<T> node, T id) {
        if (ObjectKit.equal(id, node.getId())) {
            return node;
        }
        List<Tree<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (Tree<T> child : children) {
            Tree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(Tree<T> node, boolean includeCurrentNode) {
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(node.getName());
        }
        for (Tree<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            result.add(parent.getName());
        }
        return result;
    }

    public static <E> Tree<E> createEmptyNode(E id) {
        return new Tree().setId(id);
    }
}

