/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.digest.mac;

import java.io.IOException;
import java.io.InputStream;
import org.aoju.bus.core.lang.exception.CryptoException;

public interface MacEngine {
    default public void update(byte[] in) {
        this.update(in, 0, in.length);
    }

    public void update(byte[] var1, int var2, int var3);

    public byte[] doFinal();

    public void reset();

    default public byte[] digest(InputStream data, int bufferLength) {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        byte[] buffer = new byte[bufferLength];
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.reset();
        }
        return result;
    }

    public int getMacLength();

    public String getAlgorithm();
}

