/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.ssh;

import com.jcraft.jsch.Session;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.aoju.bus.core.lang.SimpleCache;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.ssh.JSchKit;

public enum JSchSessionPool {
    INSTANCE;

    private final SimpleCache<String, Session> cache = new SimpleCache(new HashMap());

    public Session get(String key) {
        return this.cache.get(key);
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String sshPass) {
        String key = StringKit.format("{}@{}:{}", sshUser, sshHost, sshPort);
        return this.cache.get(key, Session::isConnected, () -> JSchKit.openSession(sshHost, sshPort, sshUser, sshPass));
    }

    public Session getSession(String sshHost, int sshPort, String sshUser, String prvkey, byte[] passphrase) {
        String key = StringKit.format("{}@{}:{}", sshUser, sshHost, sshPort);
        return this.cache.get(key, Session::isConnected, () -> JSchKit.openSession(sshHost, sshPort, sshUser, prvkey, passphrase));
    }

    public void put(String key, Session session) {
        this.cache.put(key, session);
    }

    public void close(String key) {
        Session session = this.get(key);
        if (null != session && session.isConnected()) {
            session.disconnect();
        }
        this.cache.remove(key);
    }

    public void remove(Session session) {
        if (null != session) {
            Iterator<Map.Entry<String, Session>> iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Session> entry = iterator.next();
                if (!session.equals(entry.getValue())) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void closeAll() {
        for (Map.Entry<String, Session> entry : this.cache) {
            Session session = entry.getValue();
            if (null == session || !session.isConnected()) continue;
            session.disconnect();
        }
        this.cache.clear();
    }
}

