/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.builtin;

import java.io.Serializable;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Platform;

public class JavaRuntime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String JAVA_RUNTIME_NAME = Platform.get(" java.runtime.name", false);
    private final String JAVA_RUNTIME_VERSION = Platform.get("java.runtime.version", false);
    private final String JAVA_HOME = Platform.get("java.home", false);
    private final String JAVA_EXT_DIRS = Platform.get("java.ext.dirs", false);
    private final String JAVA_ENDORSED_DIRS = Platform.get("java.endorsed.dirs", false);
    private final String JAVA_CLASS_PATH = Platform.get("java.class.path", false);
    private final String JAVA_CLASS_VERSION = Platform.get("java.class.version", false);
    private final String JAVA_LIBRARY_PATH = Platform.get("java.library.path", false);
    private final String SUN_BOOT_CLASS_PATH = Platform.get("sun.boot.class.path", false);
    private final String SUN_ARCH_DATA_MODEL = Platform.get("sun.arch.data.model", false);

    public final String getSunBoothClassPath() {
        return this.SUN_BOOT_CLASS_PATH;
    }

    public final String getSunArchDataModel() {
        return this.SUN_ARCH_DATA_MODEL;
    }

    public final String getName() {
        return this.JAVA_RUNTIME_NAME;
    }

    public final String getVersion() {
        return this.JAVA_RUNTIME_VERSION;
    }

    public final String getHomeDir() {
        return this.JAVA_HOME;
    }

    public final String getExtDirs() {
        return this.JAVA_EXT_DIRS;
    }

    public final String getEndorsedDirs() {
        return this.JAVA_ENDORSED_DIRS;
    }

    public final String getClassPath() {
        return this.JAVA_CLASS_PATH;
    }

    public final String[] getClassPathArray() {
        return StringKit.splitToArray(this.getClassPath(), Platform.get("path.separator", false));
    }

    public final String getClassVersion() {
        return this.JAVA_CLASS_VERSION;
    }

    public final String getLibraryPath() {
        return this.JAVA_LIBRARY_PATH;
    }

    public final String[] getLibraryPathArray() {
        return StringKit.splitToArray(this.getLibraryPath(), Platform.get("path.separator", false));
    }

    public final String getProtocolPackages() {
        return Platform.get("java.protocol.handler.pkgs", true);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        Platform.append(builder, "Java Runtime Name:      ", this.getName());
        Platform.append(builder, "Java Runtime Version:   ", this.getVersion());
        Platform.append(builder, "Java Home Dir:          ", this.getHomeDir());
        Platform.append(builder, "Java Extension Dirs:    ", this.getExtDirs());
        Platform.append(builder, "Java Endorsed Dirs:     ", this.getEndorsedDirs());
        Platform.append(builder, "Java Class Path:        ", this.getClassPath());
        Platform.append(builder, "Java Class Version:     ", this.getClassVersion());
        Platform.append(builder, "Java Library Path:      ", this.getLibraryPath());
        Platform.append(builder, "Java Protocol Packages: ", this.getProtocolPackages());
        return builder.toString();
    }
}

