/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.drivers;

import com.sun.jna.Native;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.health.builtin.software.OSSession;
import org.aoju.bus.health.mac.SystemB;

@ThreadSafe
public final class Who {
    private static final SystemB SYS = SystemB.INSTANCE;

    private Who() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<OSSession> queryUtxent() {
        ArrayList<OSSession> whoList = new ArrayList<OSSession>();
        SYS.setutxent();
        try {
            SystemB.MacUtmpx ut;
            while (null != (ut = SYS.getutxent())) {
                if (ut.ut_type != 7 && ut.ut_type != 6) continue;
                String user = Native.toString((byte[])ut.ut_user, (java.nio.charset.Charset)Charset.US_ASCII);
                String device = Native.toString((byte[])ut.ut_line, (java.nio.charset.Charset)Charset.US_ASCII);
                String host = Native.toString((byte[])ut.ut_host, (java.nio.charset.Charset)Charset.US_ASCII);
                long loginTime = ut.ut_tv.tv_sec.longValue() * 1000L + (long)ut.ut_tv.tv_usec / 1000L;
                if (user.isEmpty() || device.isEmpty() || loginTime < 0L || loginTime > System.currentTimeMillis()) {
                    List<OSSession> list = org.aoju.bus.health.unix.Who.queryWho();
                    return list;
                }
                whoList.add(new OSSession(user, device, loginTime, host));
            }
        }
        finally {
            SYS.endutxent();
        }
        return whoList;
    }
}

