/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.builtin.hardware.AbstractDisplay;
import org.aoju.bus.health.builtin.hardware.Display;
import org.aoju.bus.logger.Logger;

@Immutable
final class MacDisplay
extends AbstractDisplay {
    MacDisplay(byte[] edid) {
        super(edid);
        Logger.debug("Initialized MacDisplay", new Object[0]);
    }

    public static List<Display> getDisplays() {
        ArrayList<Display> displays = new ArrayList<Display>();
        IOKit.IOIterator serviceIterator = IOKitUtil.getMatchingServices((String)"IODisplayConnect");
        if (null != serviceIterator) {
            CoreFoundation.CFStringRef cfEdid = CoreFoundation.CFStringRef.createCFString((String)"IODisplayEDID");
            IOKit.IORegistryEntry sdService = serviceIterator.next();
            while (null != sdService) {
                IOKit.IORegistryEntry properties = sdService.getChildEntry("IOService");
                if (null != properties) {
                    CoreFoundation.CFTypeRef edidRaw = properties.createCFProperty(cfEdid);
                    if (null != edidRaw) {
                        CoreFoundation.CFDataRef edid = new CoreFoundation.CFDataRef(edidRaw.getPointer());
                        int length = edid.getLength();
                        Pointer p = edid.getBytePtr();
                        displays.add(new MacDisplay(p.getByteArray(0L, length)));
                        edid.release();
                    }
                    properties.release();
                }
                sdService.release();
                sdService = serviceIterator.next();
            }
            serviceIterator.release();
            cfEdid.release();
        }
        return displays;
    }
}

