/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.software;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.platform.mac.DiskArbitration;
import com.sun.jna.platform.mac.IOKit;
import com.sun.jna.platform.mac.IOKitUtil;
import com.sun.jna.platform.mac.SystemB;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.software.AbstractFileSystem;
import org.aoju.bus.health.builtin.software.OSFileStore;
import org.aoju.bus.health.mac.SysctlKit;
import org.aoju.bus.health.mac.drivers.WindowInfo;
import org.aoju.bus.health.mac.software.MacOSFileStore;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class MacFileSystem
extends AbstractFileSystem {
    public static final String OSHI_MAC_FS_PATH_EXCLUDES = "health.os.mac.filesystem.path.excludes";
    public static final String OSHI_MAC_FS_PATH_INCLUDES = "health.os.mac.filesystem.path.includes";
    public static final String OSHI_MAC_FS_VOLUME_EXCLUDES = "health.os.mac.filesystem.volume.excludes";
    public static final String OSHI_MAC_FS_VOLUME_INCLUDES = "health.os.mac.filesystem.volume.includes";
    private static final Pattern LOCAL_DISK = Pattern.compile("/dev/disk\\d");
    private static final List<PathMatcher> FS_PATH_EXCLUDES = Builder.loadAndParseFileSystemConfig("health.os.mac.filesystem.path.excludes");
    private static final List<PathMatcher> FS_PATH_INCLUDES = Builder.loadAndParseFileSystemConfig("health.os.mac.filesystem.path.includes");
    private static final List<PathMatcher> FS_VOLUME_EXCLUDES = Builder.loadAndParseFileSystemConfig("health.os.mac.filesystem.volume.excludes");
    private static final List<PathMatcher> FS_VOLUME_INCLUDES = Builder.loadAndParseFileSystemConfig("health.os.mac.filesystem.volume.includes");
    private static final int MNT_RDONLY = 1;
    private static final int MNT_SYNCHRONOUS = 2;
    private static final int MNT_NOEXEC = 4;
    private static final int MNT_NOSUID = 8;
    private static final int MNT_NODEV = 16;
    private static final int MNT_UNION = 32;
    private static final int MNT_ASYNC = 64;
    private static final int MNT_CPROTECT = 128;
    private static final int MNT_EXPORTED = 256;
    private static final int MNT_QUARANTINE = 1024;
    private static final int MNT_LOCAL = 4096;
    private static final int MNT_QUOTA = 8192;
    private static final int MNT_ROOTFS = 16384;
    private static final int MNT_DOVOLFS = 32768;
    private static final int MNT_DONTBROWSE = 0x100000;
    private static final int MNT_IGNORE_OWNERSHIP = 0x200000;
    private static final int MNT_AUTOMOUNTED = 0x400000;
    private static final int MNT_JOURNALED = 0x800000;
    private static final int MNT_NOUSERXATTR = 0x1000000;
    private static final int MNT_DEFWRITE = 0x2000000;
    private static final int MNT_MULTILABEL = 0x4000000;
    private static final int MNT_NOATIME = 0x10000000;
    private static final Map<Integer, String> OPTIONS_MAP = new HashMap<Integer, String>();

    public static List<OSFileStore> getFileStoreMatching(String nameToMatch) {
        return MacFileSystem.getFileStoreMatching(nameToMatch, false);
    }

    public static List<OSFileStore> getFileStoreMatching(String nameToMatch, boolean localOnly) {
        ArrayList<OSFileStore> fsList = new ArrayList<OSFileStore>();
        int numfs = SystemB.INSTANCE.getfsstat64(null, 0, 0);
        if (numfs > 0) {
            DiskArbitration.DASessionRef session = DiskArbitration.INSTANCE.DASessionCreate(CoreFoundation.INSTANCE.CFAllocatorGetDefault());
            if (null == session) {
                Logger.error("Unable to open session to DiskArbitration framework.", new Object[0]);
            } else {
                CoreFoundation.CFStringRef daVolumeNameKey = CoreFoundation.CFStringRef.createCFString((String)"DAVolumeName");
                SystemB.Statfs[] fs = new SystemB.Statfs[numfs];
                numfs = SystemB.INSTANCE.getfsstat64(fs, numfs * new SystemB.Statfs().size(), 16);
                for (int f = 0; f < numfs; ++f) {
                    String volume = Native.toString((byte[])fs[f].f_mntfromname, (Charset)StandardCharsets.UTF_8);
                    String path = Native.toString((byte[])fs[f].f_mntonname, (Charset)StandardCharsets.UTF_8);
                    String type = Native.toString((byte[])fs[f].f_fstypename, (Charset)StandardCharsets.UTF_8);
                    int flags = fs[f].f_flags;
                    if (localOnly && (flags & 0x1000) == 0 || !path.equals("/") && (PSEUDO_FS_TYPES.contains(type) || Builder.isFileStoreExcluded(path, volume, FS_PATH_INCLUDES, FS_PATH_EXCLUDES, FS_VOLUME_INCLUDES, FS_VOLUME_EXCLUDES))) continue;
                    String description = "Volume";
                    if (LOCAL_DISK.matcher(volume).matches()) {
                        description = "Local Disk";
                    } else if (volume.startsWith("localhost:") || volume.startsWith("//") || volume.startsWith("smb://") || NETWORK_FS_TYPES.contains(type)) {
                        description = "Network Drive";
                    }
                    File file = new File(path);
                    String name = file.getName();
                    if (name.isEmpty()) {
                        name = file.getPath();
                    }
                    if (null != nameToMatch && !nameToMatch.equals(name)) continue;
                    StringBuilder options = new StringBuilder((1 & flags) == 0 ? "rw" : "ro");
                    String moreOptions = OPTIONS_MAP.entrySet().stream().filter(e -> ((Integer)e.getKey() & flags) > 0).map(Map.Entry::getValue).collect(Collectors.joining(","));
                    if (!moreOptions.isEmpty()) {
                        options.append(',').append(moreOptions);
                    }
                    String uuid = "";
                    String bsdName = volume.replace("/dev/disk", "disk");
                    if (bsdName.startsWith("disk")) {
                        IOKit.IOIterator fsIter;
                        CoreFoundation.CFMutableDictionaryRef matchingDict;
                        DiskArbitration.DADiskRef disk = DiskArbitration.INSTANCE.DADiskCreateFromBSDName(CoreFoundation.INSTANCE.CFAllocatorGetDefault(), session, volume);
                        if (null != disk) {
                            CoreFoundation.CFDictionaryRef diskInfo = DiskArbitration.INSTANCE.DADiskCopyDescription(disk);
                            if (null != diskInfo) {
                                Pointer result = diskInfo.getValue((PointerType)daVolumeNameKey);
                                name = WindowInfo.cfPointerToString(result);
                                diskInfo.release();
                            }
                            disk.release();
                        }
                        if (null != (matchingDict = IOKitUtil.getBSDNameMatchingDict((String)bsdName)) && null != (fsIter = IOKitUtil.getMatchingServices((CoreFoundation.CFDictionaryRef)matchingDict))) {
                            IOKit.IORegistryEntry fsEntry = fsIter.next();
                            if (null != fsEntry && fsEntry.conformsTo("IOMedia")) {
                                uuid = fsEntry.getStringProperty("UUID");
                                if (null != uuid) {
                                    uuid = uuid.toLowerCase();
                                }
                                fsEntry.release();
                            }
                            fsIter.release();
                        }
                    }
                    fsList.add(new MacOSFileStore(name, volume, name, path, options.toString(), null == uuid ? "" : uuid, "", description, type, file.getFreeSpace(), file.getUsableSpace(), file.getTotalSpace(), fs[f].f_ffree, fs[f].f_files));
                }
                daVolumeNameKey.release();
                session.release();
            }
        }
        return fsList;
    }

    @Override
    public List<OSFileStore> getFileStores(boolean localOnly) {
        return MacFileSystem.getFileStoreMatching(null, localOnly);
    }

    @Override
    public long getOpenFileDescriptors() {
        return SysctlKit.sysctl("kern.num_files", 0);
    }

    @Override
    public long getMaxFileDescriptors() {
        return SysctlKit.sysctl("kern.maxfiles", 0);
    }

    static {
        OPTIONS_MAP.put(2, "synchronous");
        OPTIONS_MAP.put(4, "noexec");
        OPTIONS_MAP.put(8, "nosuid");
        OPTIONS_MAP.put(16, "nodev");
        OPTIONS_MAP.put(32, "union");
        OPTIONS_MAP.put(64, "asynchronous");
        OPTIONS_MAP.put(128, "content-protection");
        OPTIONS_MAP.put(256, "exported");
        OPTIONS_MAP.put(1024, "quarantined");
        OPTIONS_MAP.put(4096, "local");
        OPTIONS_MAP.put(8192, "quotas");
        OPTIONS_MAP.put(16384, "rootfs");
        OPTIONS_MAP.put(32768, "volfs");
        OPTIONS_MAP.put(0x100000, "nobrowse");
        OPTIONS_MAP.put(0x200000, "noowners");
        OPTIONS_MAP.put(0x400000, "automounted");
        OPTIONS_MAP.put(0x800000, "journaled");
        OPTIONS_MAP.put(0x1000000, "nouserxattr");
        OPTIONS_MAP.put(0x2000000, "defwrite");
        OPTIONS_MAP.put(0x4000000, "multilabel");
        OPTIONS_MAP.put(0x10000000, "noatime");
    }
}

