/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.Win32Bios;
import org.aoju.bus.health.windows.drivers.Win32ComputerSystem;
import org.aoju.bus.health.windows.drivers.Win32ComputerSystemProduct;
import org.aoju.bus.health.windows.hardware.WindowsBaseboard;
import org.aoju.bus.health.windows.hardware.WindowsFirmware;

@Immutable
final class WindowsComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Pair<String, String>> manufacturerModel = Memoize.memoize(WindowsComputerSystem::queryManufacturerModel);
    private final Supplier<Pair<String, String>> serialNumberUUID = Memoize.memoize(WindowsComputerSystem::querySystemSerialNumberUUID);

    WindowsComputerSystem() {
    }

    private static Pair<String, String> queryManufacturerModel() {
        String manufacturer = null;
        String model = null;
        WbemcliUtil.WmiResult<Win32ComputerSystem.ComputerSystemProperty> win32ComputerSystem = Win32ComputerSystem.queryComputerSystem();
        if (win32ComputerSystem.getResultCount() > 0) {
            manufacturer = WmiKit.getString(win32ComputerSystem, Win32ComputerSystem.ComputerSystemProperty.MANUFACTURER, 0);
            model = WmiKit.getString(win32ComputerSystem, Win32ComputerSystem.ComputerSystemProperty.MODEL, 0);
        }
        return Pair.of(StringKit.isBlank(manufacturer) ? "unknown" : manufacturer, StringKit.isBlank(model) ? "unknown" : model);
    }

    private static Pair<String, String> querySystemSerialNumberUUID() {
        String serialNumber = null;
        String uuid = null;
        WbemcliUtil.WmiResult<Win32ComputerSystemProduct.ComputerSystemProductProperty> win32ComputerSystemProduct = Win32ComputerSystemProduct.queryIdentifyingNumberUUID();
        if (win32ComputerSystemProduct.getResultCount() > 0) {
            serialNumber = WmiKit.getString(win32ComputerSystemProduct, Win32ComputerSystemProduct.ComputerSystemProductProperty.IDENTIFYINGNUMBER, 0);
            uuid = WmiKit.getString(win32ComputerSystemProduct, Win32ComputerSystemProduct.ComputerSystemProductProperty.UUID, 0);
        }
        if (StringKit.isBlank(serialNumber)) {
            serialNumber = WindowsComputerSystem.querySerialFromBios();
        }
        if (StringKit.isBlank(serialNumber)) {
            serialNumber = "unknown";
        }
        if (StringKit.isBlank(uuid)) {
            uuid = "unknown";
        }
        return Pair.of(serialNumber, uuid);
    }

    private static String querySerialFromBios() {
        WbemcliUtil.WmiResult<Win32Bios.BiosSerialProperty> serialNum = Win32Bios.querySerialNumber();
        if (serialNum.getResultCount() > 0) {
            return WmiKit.getString(serialNum, Win32Bios.BiosSerialProperty.SERIALNUMBER, 0);
        }
        return null;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturerModel.get().getLeft();
    }

    @Override
    public String getModel() {
        return this.manufacturerModel.get().getRight();
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumberUUID.get().getLeft();
    }

    @Override
    public String getHardwareUUID() {
        return this.serialNumberUUID.get().getRight();
    }

    @Override
    public Firmware createFirmware() {
        return new WindowsFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new WindowsBaseboard();
    }
}

