/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.magic;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Results;
import org.aoju.bus.http.bodys.ResultBody;
import org.aoju.bus.http.metric.TaskExecutor;
import org.aoju.bus.http.metric.http.CoverHttp;

public class RealResult
implements Results {
    private Results.State state;
    private Response response;
    private IOException error;
    private TaskExecutor taskExecutor;
    private CoverHttp<?> coverHttp;
    private Results.Body body;

    public RealResult(CoverHttp<?> coverHttp, Results.State state) {
        this.coverHttp = coverHttp;
        this.state = state;
    }

    public RealResult(CoverHttp<?> coverHttp, Response response, TaskExecutor taskExecutor) {
        this(coverHttp, taskExecutor);
        this.response(response);
    }

    public RealResult(CoverHttp<?> coverHttp, TaskExecutor taskExecutor) {
        this.coverHttp = coverHttp;
        this.taskExecutor = taskExecutor;
    }

    public RealResult(CoverHttp<?> coverHttp, Results.State state, IOException error) {
        this.coverHttp = coverHttp;
        this.exception(state, error);
    }

    public void exception(Results.State state, IOException error) {
        this.state = state;
        this.error = error;
    }

    public void response(Response response) {
        this.state = Results.State.RESPONSED;
        this.response = response;
    }

    @Override
    public Results.State getState() {
        return this.state;
    }

    @Override
    public int getStatus() {
        if (null != this.response) {
            return this.response.code();
        }
        return 0;
    }

    @Override
    public boolean isSuccessful() {
        if (null != this.response) {
            return this.response.isSuccessful();
        }
        return false;
    }

    @Override
    public Headers getHeaders() {
        if (null != this.response) {
            return this.response.headers();
        }
        return null;
    }

    @Override
    public List<String> getHeaders(String name) {
        if (null != this.response) {
            return this.response.headers(name);
        }
        return Collections.emptyList();
    }

    @Override
    public String getHeader(String name) {
        if (null != this.response) {
            return this.response.header(name);
        }
        return null;
    }

    @Override
    public long getContentLength() {
        String length = this.getHeader("Content-Length");
        if (null != length) {
            try {
                return Long.parseLong(length);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    @Override
    public synchronized Results.Body getBody() {
        if (null == this.body && null != this.response) {
            this.body = new ResultBody(this.coverHttp, this.response, this.taskExecutor);
        }
        return this.body;
    }

    @Override
    public IOException getError() {
        return this.error;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        Results.Body body = this.getBody();
        String text = "RealResult [\n  state: " + (Object)((Object)this.state) + ",\n  status: " + this.getStatus() + ",\n  headers: " + this.getHeaders();
        if (null != body) {
            text = text + ",\n  contentType: " + body.getType();
        }
        return text + ",\n  error: " + this.error + "\n]";
    }

    @Override
    public Results close() {
        if (null != this.response) {
            this.response.close();
        }
        return this;
    }
}

