/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.builtin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aoju.bus.image.builtin.HashUIDMapper;
import org.aoju.bus.image.builtin.UIDMapper;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.BulkData;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;

public class Multiframe {
    private static final HashMap<String, Impl> impls = new HashMap(8);
    private static final int[] EXCLUDE_TAGS = new int[]{561298, 561492, 0x209222, 0x280008, 1375769129, 1375769136, 2145386512};
    private boolean preserveSeriesInstanceUID;
    private String instanceNumberFormat = "%s%04d";
    private UIDMapper uidMapper = new HashUIDMapper();

    public static boolean isSupportedSOPClass(String cuid) {
        return impls.containsKey(cuid);
    }

    public static String legacySOPClassUID(String mfcuid) {
        Impl impl = impls.get(mfcuid);
        return null != impl ? impl.sfcuid : null;
    }

    private static Impl implFor(String mfcuid) {
        Impl impl = impls.get(mfcuid);
        if (null == impl) {
            throw new IllegalArgumentException("Unsupported SOP Class: " + mfcuid);
        }
        return impl;
    }

    public final boolean isPreserveSeriesInstanceUID() {
        return this.preserveSeriesInstanceUID;
    }

    public final void setPreserveSeriesInstanceUID(boolean preserveSeriesInstanceUID) {
        this.preserveSeriesInstanceUID = preserveSeriesInstanceUID;
    }

    public final String getInstanceNumberFormat() {
        return this.instanceNumberFormat;
    }

    public final void setInstanceNumberFormat(String instanceNumberFormat) {
        String.format(instanceNumberFormat, "1", 1);
        this.instanceNumberFormat = instanceNumberFormat;
    }

    public final UIDMapper getUIDMapper() {
        return this.uidMapper;
    }

    public final void setUIDMapper(UIDMapper uidMapper) {
        if (null == uidMapper) {
            throw new NullPointerException();
        }
        this.uidMapper = uidMapper;
    }

    public Attributes extract(Attributes emf, int frame) {
        return Multiframe.implFor(emf.getString(524310)).extract(this, emf, frame);
    }

    private Attributes extract(Attributes emf, int frame, String cuid) {
        Attributes sfgs = emf.getNestedDataset(1375769129);
        if (null == sfgs) {
            throw new IllegalArgumentException("Missing (5200,9229) Shared Functional Groups Sequence");
        }
        Attributes fgs = emf.getNestedDataset(1375769136, frame);
        if (null == fgs) {
            throw new IllegalArgumentException("Missing (5200,9230) Per-frame Functional Groups Sequence Item for frame #" + (frame + 1));
        }
        Attributes dest = new Attributes(emf.size() * 2);
        dest.addNotSelected(emf, EXCLUDE_TAGS);
        this.addFunctionGroups(dest, sfgs);
        this.addFunctionGroups(dest, fgs);
        this.addPixelData(dest, emf, frame);
        dest.setString(524310, VR.UI, cuid);
        dest.setString(524312, VR.UI, this.uidMapper.get(dest.getString(524312)) + '.' + (frame + 1));
        dest.setString(2097171, VR.IS, this.createInstanceNumber(dest.getString(2097171, ""), frame));
        dest.setString(524296, VR.CS, dest.getStrings(561159));
        dest.remove(561159);
        if (!this.preserveSeriesInstanceUID) {
            dest.setString(0x20000E, VR.UI, this.uidMapper.get(dest.getString(0x20000E)));
        }
        this.adjustReferencedImages(dest, 528704);
        this.adjustReferencedImages(dest, 532754);
        return dest;
    }

    private void adjustReferencedImages(Attributes attrs, int sqtag) {
        Sequence sq = attrs.getSequence(sqtag);
        if (null == sq) {
            return;
        }
        ArrayList<Attributes> newRefs = new ArrayList<Attributes>();
        Iterator itr = sq.iterator();
        while (itr.hasNext()) {
            Attributes ref = (Attributes)itr.next();
            String cuid = Multiframe.legacySOPClassUID(ref.getString(528720));
            if (null == cuid) continue;
            itr.remove();
            String iuid = this.uidMapper.get(ref.getString(528725));
            int[] frames = ref.getInts(528736);
            int n = null == frames ? 1 : frames.length;
            ref.remove(528736);
            ref.setString(528720, VR.UI, cuid);
            for (int i = 0; i < n; ++i) {
                Attributes newRef = new Attributes(ref);
                newRef.setString(528725, VR.UI, iuid + '.' + (null != frames ? frames[i] : i + 1));
                newRefs.add(newRef);
            }
        }
        for (Attributes ref : newRefs) {
            sq.add(ref);
        }
    }

    private void addFunctionGroups(Attributes dest, Attributes fgs) {
        dest.addSelected(fgs, 528704);
        for (int sqTag : fgs.tags()) {
            Attributes fg;
            if (sqTag == 528704 || null == (fg = fgs.getNestedDataset(sqTag))) continue;
            dest.addAll(fg);
        }
    }

    private void addPixelData(Attributes dest, Attributes src, int frame) {
        VR.Holder vr = new VR.Holder();
        Object pixelData = src.getValue(2145386512, vr);
        if (pixelData instanceof byte[]) {
            dest.setBytes(2145386512, vr.vr, this.extractPixelData((byte[])pixelData, frame, this.calcFrameLength(src)));
        } else if (pixelData instanceof BulkData) {
            dest.setValue(2145386512, vr.vr, this.extractPixelData((BulkData)pixelData, frame, this.calcFrameLength(src)));
        } else {
            Fragments destFrags = dest.newFragments(2145386512, vr.vr, 2);
            destFrags.add((Object)null);
            destFrags.add(((Fragments)pixelData).get(frame + 1));
        }
    }

    private BulkData extractPixelData(BulkData src, int frame, int length) {
        return new BulkData(src.uriWithoutOffsetAndLength(), src.offset() + (long)(frame * length), length, src.bigEndian());
    }

    private byte[] extractPixelData(byte[] src, int frame, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(src, frame * length, dest, 0, length);
        return dest;
    }

    private int calcFrameLength(Attributes src) {
        return src.getInt(2621456, 0) * src.getInt(2621457, 0) * (src.getInt(2621696, 8) >> 3) * src.getInt(1342185478, 1);
    }

    private String createInstanceNumber(String mfinstno, int frame) {
        String s = String.format(this.instanceNumberFormat, mfinstno, frame + 1);
        return s.length() > 16 ? s.substring(s.length() - 16) : s;
    }

    static {
        impls.put("1.2.840.10008.5.1.4.1.1.2.1", Impl.EnhancedCTImageExtractor);
        impls.put("1.2.840.10008.5.1.4.1.1.4.1", Impl.EnhancedMRImageExtractor);
        impls.put("1.2.840.10008.5.1.4.1.1.130", Impl.EnhancedPETImageExtractor);
    }

    private static enum Impl {
        EnhancedCTImageExtractor("1.2.840.10008.5.1.4.1.1.2"),
        EnhancedMRImageExtractor("1.2.840.10008.5.1.4.1.1.4"){

            @Override
            Attributes extract(Multiframe mfe, Attributes emf, int frame) {
                Attributes sf = super.extract(mfe, emf, frame);
                this.setEchoTime(sf);
                this.setScanningSequence(sf);
                this.setSequenceVariant(sf);
                this.setScanOptions(sf);
                return sf;
            }

            void setEchoTime(Attributes sf) {
                double echoTime = sf.getDouble(1609858, 0.0);
                if (echoTime == 0.0) {
                    sf.setNull(0x180081, VR.DS);
                } else {
                    sf.setDouble(0x180081, VR.DS, echoTime);
                }
            }

            void setScanningSequence(Attributes sf) {
                ArrayList<String> list = new ArrayList<String>(3);
                String eps = sf.getString(1609736);
                if (!"GRADIENT".equals(eps)) {
                    list.add("SE");
                }
                if (!"SPIN".equals(eps)) {
                    list.add("GR");
                }
                if ("YES".equals(sf.getString(1609737))) {
                    list.add("IR");
                }
                if ("YES".equals(sf.getString(1609752))) {
                    list.add("EP");
                }
                sf.setString(1572896, VR.CS, list.toArray(new String[list.size()]));
            }

            void setSequenceVariant(Attributes sf) {
                String op;
                String sp;
                String ssps;
                String mf;
                ArrayList<String> list = new ArrayList<String>(5);
                if (!"SINGLE".equals(sf.getString(1609779))) {
                    list.add("SK");
                }
                if (null != (mf = sf.getString(1609760)) && !"NONE".equals(mf)) {
                    list.add("MTC");
                }
                if (null != (ssps = sf.getString(1609751)) && !"NONE".equals(ssps)) {
                    list.add("TIME_REVERSED".equals(ssps) ? "TRSS" : "SS");
                }
                if (null != (sp = sf.getString(1609750)) && !"NONE".equals(sp)) {
                    list.add("SP");
                }
                if (null != (op = sf.getString(1609769)) && !"NONE".equals(op)) {
                    list.add("OSP");
                }
                if (list.isEmpty()) {
                    list.add("NONE");
                }
                sf.setString(1572897, VR.CS, list.toArray(new String[list.size()]));
            }

            void setScanOptions(Attributes sf) {
                String fc;
                String sss;
                String sp;
                String pfd;
                String frameType3;
                ArrayList<String> list = new ArrayList<String>(3);
                String per = sf.getString(1609780);
                if (null != per && !"LINEAR".equals(per)) {
                    list.add("PER");
                }
                if ("ANGIO".equals(frameType3 = sf.getString(524296, 2))) {
                    sf.setString(1572901, VR.CS, "Y");
                }
                if (frameType3.startsWith("CARD")) {
                    list.add("CG");
                }
                if (frameType3.endsWith("RESP_GATED")) {
                    list.add("RG");
                }
                if ("PHASE".equals(pfd = sf.getString(1609782))) {
                    list.add("PFP");
                }
                if ("FREQUENCY".equals(pfd)) {
                    list.add("PFF");
                }
                if (null != (sp = sf.getString(1609767)) && !"NONE".equals(sp)) {
                    list.add("SP");
                }
                if (null != (sss = sf.getString(1609765)) && sss.startsWith("FAT")) {
                    list.add("FS");
                }
                if (null != (fc = sf.getString(1609744)) && !"NONE".equals(fc)) {
                    list.add("FC");
                }
                sf.setString(1572898, VR.CS, list.toArray(new String[list.size()]));
            }
        }
        ,
        EnhancedPETImageExtractor("1.2.840.10008.5.1.4.1.1.128");

        private final String sfcuid;

        private Impl(String sfcuid) {
            this.sfcuid = sfcuid;
        }

        Attributes extract(Multiframe mfe, Attributes emf, int frame) {
            return mfe.extract(emf, frame, this.sfcuid);
        }
    }
}

