/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.io.BasicBulkDataDescriptor;
import org.aoju.bus.image.galaxy.io.ContentHandlerAdapter;
import org.aoju.bus.image.galaxy.io.ImageEncodingOptions;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.ImageOutputStream;
import org.xml.sax.helpers.DefaultHandler;

public class Xml2Dcm {
    private final BasicBulkDataDescriptor bulkDataDescriptor = new BasicBulkDataDescriptor();
    private ImageInputStream.IncludeBulkData includeBulkData = ImageInputStream.IncludeBulkData.URI;
    private boolean catBlkFiles = false;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private String tsuid;
    private boolean withfmi;
    private boolean nofmi;
    private ImageEncodingOptions encOpts = ImageEncodingOptions.DEFAULT;
    private List<File> bulkDataFiles;
    private Attributes fmi;
    private Attributes dataset;

    public static Attributes parseXML(String fname) throws Exception {
        Attributes attrs = new Attributes();
        ContentHandlerAdapter ch = new ContentHandlerAdapter(attrs);
        Xml2Dcm.parseXML(fname, ch);
        return attrs;
    }

    private static void parseXML(String fname, ContentHandlerAdapter ch) throws Exception {
        SAXParserFactory f = SAXParserFactory.newInstance();
        SAXParser p = f.newSAXParser();
        if (fname.equals("-")) {
            p.parse(System.in, (DefaultHandler)ch);
        } else {
            p.parse(new File(fname), (DefaultHandler)ch);
        }
    }

    public final void setIncludeBulkData(ImageInputStream.IncludeBulkData includeBulkData) {
        this.includeBulkData = includeBulkData;
    }

    public final void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.catBlkFiles = catBlkFiles;
    }

    public final void setBulkDataFilePrefix(String blkFilePrefix) {
        this.blkFilePrefix = blkFilePrefix;
    }

    public final void setBulkDataFileSuffix(String blkFileSuffix) {
        this.blkFileSuffix = blkFileSuffix;
    }

    public final void setBulkDataDirectory(File blkDirectory) {
        this.blkDirectory = blkDirectory;
    }

    public void setBulkDataNoDefaults(boolean excludeDefaults) {
        this.bulkDataDescriptor.excludeDefaults(excludeDefaults);
    }

    public void setBulkDataLengthsThresholdsFromStrings(String[] thresholds) {
        this.bulkDataDescriptor.setLengthsThresholdsFromStrings(thresholds);
    }

    public final void setTransferSyntax(String uid) {
        this.tsuid = uid;
    }

    public final void setWithFileMetaInformation(boolean withfmi) {
        this.withfmi = withfmi;
    }

    public final void setNoFileMetaInformation(boolean nofmi) {
        this.nofmi = nofmi;
    }

    public final void setEncodingOptions(ImageEncodingOptions encOpts) {
        this.encOpts = encOpts;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (this.nofmi) {
            this.fmi = null;
        } else if (null == this.fmi ? this.withfmi : null != this.tsuid && !this.tsuid.equals(this.fmi.getString(131088, null))) {
            this.fmi = this.dataset.createFileMetaInformation(this.tsuid);
        }
        ImageOutputStream dos = new ImageOutputStream(new BufferedOutputStream(out), null != this.fmi ? "1.2.840.10008.1.2.1" : (null != this.tsuid ? this.tsuid : "1.2.840.10008.1.2"));
        dos.setEncodingOptions(this.encOpts);
        dos.writeDataset(this.fmi, this.dataset);
        dos.finish();
        dos.flush();
    }

    public void delBulkDataFiles() {
        if (null != this.bulkDataFiles) {
            for (File f : this.bulkDataFiles) {
                f.delete();
            }
        }
    }

    public void parse(ImageInputStream dis) throws IOException {
        dis.setIncludeBulkData(this.includeBulkData);
        dis.setBulkDataDescriptor(this.bulkDataDescriptor);
        dis.setBulkDataDirectory(this.blkDirectory);
        dis.setBulkDataFilePrefix(this.blkFilePrefix);
        dis.setBulkDataFileSuffix(this.blkFileSuffix);
        dis.setConcatenateBulkDataFiles(this.catBlkFiles);
        this.dataset = dis.readDataset(-1, -1);
        this.fmi = dis.getFileMetaInformation();
        this.bulkDataFiles = dis.getBulkDataFiles();
    }

    public void mergeXML(String fname) throws Exception {
        if (null == this.dataset) {
            this.dataset = new Attributes();
        }
        ContentHandlerAdapter ch = new ContentHandlerAdapter(this.dataset);
        Xml2Dcm.parseXML(fname, ch);
        Attributes fmi2 = ch.getFileMetaInformation();
        if (null != fmi2) {
            this.fmi = fmi2;
        }
    }
}

