/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.aliyun;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.UUID;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.aliyun.AliyunProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunVmsProperty;

public class AliyunVmsProvider
extends AliyunProvider<AliyunVmsProperty, Context> {
    private static final String ALIYUN_VMS_API = "dyvmsapi.aliyuncs.com";

    public AliyunVmsProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(AliyunVmsProperty entity) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(new SimpleTimeZone(0, "UTC"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SignatureMethod", "HMAC-SHA1");
        params.put("SignatureNonce", UUID.randomUUID().toString());
        params.put("AccessKeyId", this.properties.getAppKey());
        params.put("SignatureVersion", "1.0");
        params.put("Timestamp", df.format(new Date()));
        params.put("Format", "JSON");
        params.put("Action", "SingleCallByTts");
        params.put("Version", "2017-05-25");
        params.put("RegionId", "cn-hangzhou");
        params.put("CalledNumber", entity.getReceive());
        params.put("CalledShowNumber", this.properties.getShowNumber());
        params.put("PlayTimes", entity.getPlayTimes());
        params.put("TtsParam", entity.getTtsParam());
        params.put("TtsCode", entity.getTtsCode());
        params.put("Signature", this.getSign(params));
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String text : params.keySet()) {
            map.put(this.specialUrlEncode(text), this.specialUrlEncode((String)params.get(text)));
        }
        return this.checkResponse(Httpx.get("https://dyvmsapi.aliyuncs.com", map));
    }
}

