/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.draw;

import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.lang.XComponent;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Draw;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public class PageSelectorFilter
implements Filter {
    private final int page;

    public PageSelectorFilter(int page) {
        this.page = page;
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws Exception {
        Logger.debug("Applying the PageSelectorFilter", new Object[0]);
        if (Draw.isDraw(document)) {
            this.selectPage(document);
        }
        chain.doFilter(context, document);
    }

    private void selectPage(XComponent document) throws Exception {
        XDrawPages drawPages = Lo.qi(XDrawPagesSupplier.class, document).getDrawPages();
        int pageCount = drawPages.getCount();
        int seekIdx = Math.min(pageCount, Math.max(0, this.page - 1));
        for (int i = 0; i < pageCount; ++i) {
            XDrawPage drawPage = null;
            if (i < seekIdx) {
                drawPage = Lo.qi(XDrawPage.class, drawPages.getByIndex(0));
            } else if (i > seekIdx) {
                drawPage = Lo.qi(XDrawPage.class, drawPages.getByIndex(1));
            }
            if (null == drawPage) continue;
            drawPages.remove(drawPage);
        }
    }
}

