/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter.text;

import com.sun.star.lang.XComponent;
import com.sun.star.util.XReplaceDescriptor;
import com.sun.star.util.XReplaceable;
import com.sun.star.util.XSearchDescriptor;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.Write;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public class TextReplacerFilter
implements Filter {
    private final String[] searchList;
    private final String[] replacementList;

    public TextReplacerFilter(String[] searchList, String[] replacementList) {
        this.searchList = ArrayKit.clone(searchList);
        this.replacementList = ArrayKit.clone(replacementList);
    }

    @Override
    public void doFilter(Context context, XComponent document, FilterChain chain) throws InstrumentException {
        Logger.debug("Applying the TextReplacerFilter", new Object[0]);
        if (Write.isText(document)) {
            this.replaceText(document);
        }
        chain.doFilter(context, document);
    }

    private void replaceText(XComponent document) {
        XReplaceable replaceable = Lo.qi(XReplaceable.class, document);
        XReplaceDescriptor replaceDescr = replaceable.createReplaceDescriptor();
        Logger.debug("Changing all occurrences of ...", new Object[0]);
        for (int i = 0; i < this.searchList.length; ++i) {
            Logger.debug("{} -> {}", this.searchList[i], this.replacementList[i]);
            replaceDescr.setSearchString(this.searchList[i]);
            replaceDescr.setReplaceString(this.replacementList[i]);
            replaceable.replaceAll((XSearchDescriptor)replaceDescr);
        }
    }
}

