/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pager.dialect.rowbounds;

import java.util.Properties;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pager.dialect.AbstractRowBounds;
import org.aoju.bus.pager.dialect.ReplaceSql;
import org.aoju.bus.pager.dialect.replace.RegexWithNolock;
import org.aoju.bus.pager.dialect.replace.SimpleWithNolock;
import org.aoju.bus.pager.parser.SqlServerParser;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.RowBounds;

public class SqlServerRowBounds
extends AbstractRowBounds {
    protected SqlServerParser pageSql = new SqlServerParser();
    protected ReplaceSql replaceSql;

    @Override
    public String getCountSql(MappedStatement ms, BoundSql boundSql, Object parameterObject, RowBounds rowBounds, CacheKey countKey) {
        String sql = boundSql.getSql();
        sql = this.replaceSql.replace(sql);
        sql = this.countSqlParser.getSmartCountSql(sql);
        sql = this.replaceSql.restore(sql);
        return sql;
    }

    @Override
    public String getPageSql(String sql, RowBounds rowBounds, CacheKey pageKey) {
        pageKey.update((Object)rowBounds.getOffset());
        pageKey.update((Object)rowBounds.getLimit());
        sql = this.replaceSql.replace(sql);
        sql = this.pageSql.convertToPageSql(sql, null, null);
        sql = this.replaceSql.restore(sql);
        sql = sql.replace(String.valueOf(Long.MIN_VALUE), String.valueOf(rowBounds.getOffset()));
        sql = sql.replace(String.valueOf(Long.MAX_VALUE), String.valueOf(rowBounds.getLimit()));
        return sql;
    }

    @Override
    public void setProperties(Properties properties) {
        super.setProperties(properties);
        String replaceSql = properties.getProperty("replaceSql");
        if (StringKit.isEmpty(replaceSql) || "simple".equalsIgnoreCase(replaceSql)) {
            this.replaceSql = new SimpleWithNolock();
        } else if ("regex".equalsIgnoreCase(replaceSql)) {
            this.replaceSql = new RegexWithNolock();
        } else {
            try {
                this.replaceSql = (ReplaceSql)Class.forName(replaceSql).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("replaceSql \u53c2\u6570\u914d\u7f6e\u7684\u503c\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u53ef\u9009\u503c\u4e3a simple \u548c regex\uff0c\u6216\u8005\u662f\u5b9e\u73b0\u4e86 " + ReplaceSql.class.getCanonicalName() + " \u63a5\u53e3\u7684\u5168\u9650\u5b9a\u7c7b\u540d", e);
            }
        }
    }
}

