/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.getter.OptNullString;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public abstract class AbstractSetting
implements OptNullString<String>,
Serializable {
    @Override
    public String getStr(String key, String defaultValue) {
        return this.getStr(key, "", defaultValue);
    }

    public String getStr(String key, String group, String defaultValue) {
        return ObjectKit.defaultIfNull(this.getByGroup(key, group), defaultValue);
    }

    public String getStrNotEmpty(String key, String group, String defaultValue) {
        return ObjectKit.defaultIfEmpty(this.getByGroup(key, group), defaultValue);
    }

    public abstract String getByGroup(String var1, String var2);

    public String getWithLog(String key) {
        return this.getStr(key);
    }

    public String getByGroupWithLog(String key, String group) {
        return this.getByGroup(key, group);
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, ",");
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getByGroup(key, group);
        if (StringKit.isBlank(value)) {
            return null;
        }
        return StringKit.splitToArray(value, delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Convert.toInt(this.getByGroup(key, group), defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Convert.toBool(this.getByGroup(key, group), defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Convert.toLong(this.getByGroup(key, group), defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.getByGroup(key, group);
        if (StringKit.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Convert.toDouble(this.getByGroup(key, group), defaultValue);
    }

    public <T> T toBean(final String group, T bean) {
        return BeanKit.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                return AbstractSetting.this.getByGroup(key, group);
            }

            @Override
            public boolean containsKey(String key) {
                return null != AbstractSetting.this.getByGroup(key, group);
            }
        }, CopyOptions.create());
    }

    public <T> T toBean(T bean) {
        return this.toBean(null, bean);
    }
}

