/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2021 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.image.metric;

import org.aoju.bus.image.galaxy.data.Attributes;

import java.io.IOException;

/**
 * @author Kimi Liu
 * @version 6.3.1
 * @since JDK 1.8+
 */
public interface DimseRSP {

    /**
     * 发送下一个响应，完成后返回false
     *
     * @return 如果有更多要发送的响应，则为True
     * @throws IOException          网络交互中是否有问题
     * @throws InterruptedException 如果线程被中断
     */
    boolean next() throws IOException, InterruptedException;

    /**
     * 获取响应命令对象
     *
     * @return 属性命令对象
     */
    Attributes getCommand();

    /**
     * 获取此响应中包含的数据集，如果没有数据集，则为null
     *
     * @return 属性此响应中包含的数据集(如果有)
     */
    Attributes getDataset();

    /**
     * 如果这是可以取消*的DIMSE操作(例如C-FIND)，请取消操作
     *
     * @param association 关联活动的关联对象
     * @throws IOException 网络交互中是否有问题。
     */
    void cancel(Association association) throws IOException;

}
