/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2021 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.office;

import org.aoju.bus.office.builtin.OptionalSource;
import org.aoju.bus.office.magic.family.DocumentFormat;
import org.aoju.bus.office.magic.family.FormatRegistry;

import java.io.File;
import java.io.InputStream;

/**
 * 文档转换服务提供者.
 * 负责使用office管理器执行文档的转换.
 *
 * @author Kimi Liu
 * @version 6.3.1
 * @since JDK 1.8+
 */
public interface Provider {

    /**
     * 转换存储在本地文件系统上的源文件.
     *
     * @param source 转换输入作为一个文件.
     * @return 当前转换规范.
     */
    OptionalSource convert(File source);

    /**
     * 转换源流输入流.
     *
     * @param source 转换输入作为输入流.
     * @return 当前转换规范.
     */
    OptionalSource convert(InputStream source);

    /**
     * 转换源流输入流.
     *
     * @param source      转换输入作为输入流.
     * @param closeStream 是否在转换结束后关闭{@link InputStream}.
     * @return 当前转换规范.
     */
    OptionalSource convert(InputStream source, boolean closeStream);

    /**
     * 获取转换器支持的所有{@link DocumentFormat}.
     *
     * @return 包含支持格式的{@link FormatRegistry}.
     */
    FormatRegistry getFormatRegistry();

}
