/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core;

import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Version {
    private boolean complete = true;

    public static String get() {
        return "6.3.1.RELEASE";
    }

    public static String major() {
        return StringKit.splitToArray(Version.get(), ".")[0];
    }

    public static String minor() {
        return StringKit.splitToArray(Version.get(), ".")[1];
    }

    public static String stage() {
        return StringKit.splitToArray(Version.get(), ".")[2];
    }

    public static String level() {
        return StringKit.splitToArray(Version.get(), ".")[3];
    }

    public static String all() {
        return Version.major() + Version.minor() + Version.stage();
    }

    public Version inComplete() {
        this.complete = false;
        return this;
    }

    public boolean eq(String version) {
        return this.compare(version) == 0;
    }

    public boolean ne(String version) {
        return this.compare(version) != 0;
    }

    public boolean gt(String version) {
        return this.compare(version) > 0;
    }

    public boolean gte(String version) {
        return this.compare(version) >= 0;
    }

    public boolean lt(String version) {
        return this.compare(version) < 0;
    }

    public boolean lte(String version) {
        return this.compare(version) <= 0;
    }

    private int compare(String version) {
        return ObjectKit.compare(Version.get(), version, this.complete);
    }
}

