/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compress;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.aoju.bus.core.toolkit.StringKit;

public class ZipCopyVisitor
extends SimpleFileVisitor<Path> {
    private final Path source;
    private final FileSystem fileSystem;
    private final CopyOption[] copyOptions;

    public ZipCopyVisitor(Path source, FileSystem fileSystem, CopyOption ... copyOptions) {
        this.source = source;
        this.fileSystem = fileSystem;
        this.copyOptions = copyOptions;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        block3: {
            Path targetDir = this.resolveTarget(dir);
            if (StringKit.isNotEmpty(targetDir.toString())) {
                try {
                    Files.copy(dir, targetDir, this.copyOptions);
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetDir, new LinkOption[0])) break block3;
                    throw e;
                }
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.copy(file, this.resolveTarget(file), this.copyOptions);
        return FileVisitResult.CONTINUE;
    }

    private Path resolveTarget(Path file) {
        return this.fileSystem.getPath(this.source.relativize(file).toString(), new String[0]);
    }
}

